/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EncodedIssuerCertificateInfo;
import com.azure.resourcemanager.eventgrid.models.IssuerCertificateInfo;
import java.io.IOException;
import java.util.List;

public final class CustomJwtAuthenticationSettings
implements JsonSerializable<CustomJwtAuthenticationSettings> {
    private String tokenIssuer;
    private List<IssuerCertificateInfo> issuerCertificates;
    private List<EncodedIssuerCertificateInfo> encodedIssuerCertificates;

    public String tokenIssuer() {
        return this.tokenIssuer;
    }

    public CustomJwtAuthenticationSettings withTokenIssuer(String tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
        return this;
    }

    public List<IssuerCertificateInfo> issuerCertificates() {
        return this.issuerCertificates;
    }

    public CustomJwtAuthenticationSettings withIssuerCertificates(List<IssuerCertificateInfo> issuerCertificates) {
        this.issuerCertificates = issuerCertificates;
        return this;
    }

    public List<EncodedIssuerCertificateInfo> encodedIssuerCertificates() {
        return this.encodedIssuerCertificates;
    }

    public CustomJwtAuthenticationSettings withEncodedIssuerCertificates(List<EncodedIssuerCertificateInfo> encodedIssuerCertificates) {
        this.encodedIssuerCertificates = encodedIssuerCertificates;
        return this;
    }

    public void validate() {
        if (this.issuerCertificates() != null) {
            this.issuerCertificates().forEach(e -> e.validate());
        }
        if (this.encodedIssuerCertificates() != null) {
            this.encodedIssuerCertificates().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tokenIssuer", this.tokenIssuer);
        jsonWriter.writeArrayField("issuerCertificates", this.issuerCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("encodedIssuerCertificates", this.encodedIssuerCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomJwtAuthenticationSettings fromJson(JsonReader jsonReader) throws IOException {
        return (CustomJwtAuthenticationSettings)jsonReader.readObject(reader -> {
            CustomJwtAuthenticationSettings deserializedCustomJwtAuthenticationSettings = new CustomJwtAuthenticationSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tokenIssuer".equals(fieldName)) {
                    deserializedCustomJwtAuthenticationSettings.tokenIssuer = reader.getString();
                    continue;
                }
                if ("issuerCertificates".equals(fieldName)) {
                    List issuerCertificates;
                    deserializedCustomJwtAuthenticationSettings.issuerCertificates = issuerCertificates = reader.readArray(reader1 -> IssuerCertificateInfo.fromJson(reader1));
                    continue;
                }
                if ("encodedIssuerCertificates".equals(fieldName)) {
                    List encodedIssuerCertificates;
                    deserializedCustomJwtAuthenticationSettings.encodedIssuerCertificates = encodedIssuerCertificates = reader.readArray(reader1 -> EncodedIssuerCertificateInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomJwtAuthenticationSettings;
        });
    }
}

