/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CustomDomainIdentity;
import com.azure.resourcemanager.eventgrid.models.CustomDomainValidationState;
import java.io.IOException;

public final class CustomDomainConfiguration
implements JsonSerializable<CustomDomainConfiguration> {
    private String fullyQualifiedDomainName;
    private CustomDomainValidationState validationState;
    private CustomDomainIdentity identity;
    private String certificateUrl;
    private String expectedTxtRecordName;
    private String expectedTxtRecordValue;
    private static final ClientLogger LOGGER = new ClientLogger(CustomDomainConfiguration.class);

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public CustomDomainConfiguration withFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        return this;
    }

    public CustomDomainValidationState validationState() {
        return this.validationState;
    }

    public CustomDomainConfiguration withValidationState(CustomDomainValidationState validationState) {
        this.validationState = validationState;
        return this;
    }

    public CustomDomainIdentity identity() {
        return this.identity;
    }

    public CustomDomainConfiguration withIdentity(CustomDomainIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String certificateUrl() {
        return this.certificateUrl;
    }

    public CustomDomainConfiguration withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    public String expectedTxtRecordName() {
        return this.expectedTxtRecordName;
    }

    public CustomDomainConfiguration withExpectedTxtRecordName(String expectedTxtRecordName) {
        this.expectedTxtRecordName = expectedTxtRecordName;
        return this;
    }

    public String expectedTxtRecordValue() {
        return this.expectedTxtRecordValue;
    }

    public CustomDomainConfiguration withExpectedTxtRecordValue(String expectedTxtRecordValue) {
        this.expectedTxtRecordValue = expectedTxtRecordValue;
        return this;
    }

    public void validate() {
        if (this.fullyQualifiedDomainName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fullyQualifiedDomainName in model CustomDomainConfiguration"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fullyQualifiedDomainName", this.fullyQualifiedDomainName);
        jsonWriter.writeStringField("validationState", this.validationState == null ? null : this.validationState.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("certificateUrl", this.certificateUrl);
        jsonWriter.writeStringField("expectedTxtRecordName", this.expectedTxtRecordName);
        jsonWriter.writeStringField("expectedTxtRecordValue", this.expectedTxtRecordValue);
        return jsonWriter.writeEndObject();
    }

    public static CustomDomainConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (CustomDomainConfiguration)jsonReader.readObject(reader -> {
            CustomDomainConfiguration deserializedCustomDomainConfiguration = new CustomDomainConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.fullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("validationState".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.validationState = CustomDomainValidationState.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.identity = CustomDomainIdentity.fromJson(reader);
                    continue;
                }
                if ("certificateUrl".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.certificateUrl = reader.getString();
                    continue;
                }
                if ("expectedTxtRecordName".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.expectedTxtRecordName = reader.getString();
                    continue;
                }
                if ("expectedTxtRecordValue".equals(fieldName)) {
                    deserializedCustomDomainConfiguration.expectedTxtRecordValue = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomDomainConfiguration;
        });
    }
}

