/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AlternativeAuthenticationNameSource;
import com.azure.resourcemanager.eventgrid.models.CustomJwtAuthenticationSettings;
import com.azure.resourcemanager.eventgrid.models.WebhookAuthenticationSettings;
import java.io.IOException;
import java.util.List;

public final class ClientAuthenticationSettings
implements JsonSerializable<ClientAuthenticationSettings> {
    private List<AlternativeAuthenticationNameSource> alternativeAuthenticationNameSources;
    private CustomJwtAuthenticationSettings customJwtAuthentication;
    private WebhookAuthenticationSettings webhookAuthentication;

    public List<AlternativeAuthenticationNameSource> alternativeAuthenticationNameSources() {
        return this.alternativeAuthenticationNameSources;
    }

    public ClientAuthenticationSettings withAlternativeAuthenticationNameSources(List<AlternativeAuthenticationNameSource> alternativeAuthenticationNameSources) {
        this.alternativeAuthenticationNameSources = alternativeAuthenticationNameSources;
        return this;
    }

    public CustomJwtAuthenticationSettings customJwtAuthentication() {
        return this.customJwtAuthentication;
    }

    public ClientAuthenticationSettings withCustomJwtAuthentication(CustomJwtAuthenticationSettings customJwtAuthentication) {
        this.customJwtAuthentication = customJwtAuthentication;
        return this;
    }

    public WebhookAuthenticationSettings webhookAuthentication() {
        return this.webhookAuthentication;
    }

    public ClientAuthenticationSettings withWebhookAuthentication(WebhookAuthenticationSettings webhookAuthentication) {
        this.webhookAuthentication = webhookAuthentication;
        return this;
    }

    public void validate() {
        if (this.customJwtAuthentication() != null) {
            this.customJwtAuthentication().validate();
        }
        if (this.webhookAuthentication() != null) {
            this.webhookAuthentication().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("alternativeAuthenticationNameSources", this.alternativeAuthenticationNameSources, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("customJwtAuthentication", (JsonSerializable)this.customJwtAuthentication);
        jsonWriter.writeJsonField("webhookAuthentication", (JsonSerializable)this.webhookAuthentication);
        return jsonWriter.writeEndObject();
    }

    public static ClientAuthenticationSettings fromJson(JsonReader jsonReader) throws IOException {
        return (ClientAuthenticationSettings)jsonReader.readObject(reader -> {
            ClientAuthenticationSettings deserializedClientAuthenticationSettings = new ClientAuthenticationSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alternativeAuthenticationNameSources".equals(fieldName)) {
                    List alternativeAuthenticationNameSources;
                    deserializedClientAuthenticationSettings.alternativeAuthenticationNameSources = alternativeAuthenticationNameSources = reader.readArray(reader1 -> AlternativeAuthenticationNameSource.fromString(reader1.getString()));
                    continue;
                }
                if ("customJwtAuthentication".equals(fieldName)) {
                    deserializedClientAuthenticationSettings.customJwtAuthentication = CustomJwtAuthenticationSettings.fromJson(reader);
                    continue;
                }
                if ("webhookAuthentication".equals(fieldName)) {
                    deserializedClientAuthenticationSettings.webhookAuthentication = WebhookAuthenticationSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientAuthenticationSettings;
        });
    }
}

