/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.ChannelInner;
import java.io.IOException;
import java.util.List;

public final class ChannelsListResult
implements JsonSerializable<ChannelsListResult> {
    private List<ChannelInner> value;
    private String nextLink;

    public List<ChannelInner> value() {
        return this.value;
    }

    public ChannelsListResult withValue(List<ChannelInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ChannelsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ChannelsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ChannelsListResult)jsonReader.readObject(reader -> {
            ChannelsListResult deserializedChannelsListResult = new ChannelsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedChannelsListResult.value = value = reader.readArray(reader1 -> ChannelInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedChannelsListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChannelsListResult;
        });
    }
}

