/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilterOperatorType;
import java.io.IOException;

public final class BoolEqualsAdvancedFilter
extends AdvancedFilter {
    private AdvancedFilterOperatorType operatorType = AdvancedFilterOperatorType.BOOL_EQUALS;
    private Boolean value;

    @Override
    public AdvancedFilterOperatorType operatorType() {
        return this.operatorType;
    }

    public Boolean value() {
        return this.value;
    }

    public BoolEqualsAdvancedFilter withValue(Boolean value) {
        this.value = value;
        return this;
    }

    @Override
    public BoolEqualsAdvancedFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeBooleanField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static BoolEqualsAdvancedFilter fromJson(JsonReader jsonReader) throws IOException {
        return (BoolEqualsAdvancedFilter)jsonReader.readObject(reader -> {
            BoolEqualsAdvancedFilter deserializedBoolEqualsAdvancedFilter = new BoolEqualsAdvancedFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedBoolEqualsAdvancedFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedBoolEqualsAdvancedFilter.operatorType = AdvancedFilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedBoolEqualsAdvancedFilter.value = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBoolEqualsAdvancedFilter;
        });
    }
}

