/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.AzureFunctionEventSubscriptionDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMapping;
import com.azure.resourcemanager.eventgrid.models.EndpointType;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import java.io.IOException;
import java.util.List;

public final class AzureFunctionEventSubscriptionDestination
extends EventSubscriptionDestination {
    private EndpointType endpointType = EndpointType.AZURE_FUNCTION;
    private AzureFunctionEventSubscriptionDestinationProperties innerProperties;

    @Override
    public EndpointType endpointType() {
        return this.endpointType;
    }

    AzureFunctionEventSubscriptionDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public AzureFunctionEventSubscriptionDestination withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFunctionEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    public Integer maxEventsPerBatch() {
        return this.innerProperties() == null ? null : this.innerProperties().maxEventsPerBatch();
    }

    public AzureFunctionEventSubscriptionDestination withMaxEventsPerBatch(Integer maxEventsPerBatch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFunctionEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withMaxEventsPerBatch(maxEventsPerBatch);
        return this;
    }

    public Integer preferredBatchSizeInKilobytes() {
        return this.innerProperties() == null ? null : this.innerProperties().preferredBatchSizeInKilobytes();
    }

    public AzureFunctionEventSubscriptionDestination withPreferredBatchSizeInKilobytes(Integer preferredBatchSizeInKilobytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFunctionEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withPreferredBatchSizeInKilobytes(preferredBatchSizeInKilobytes);
        return this;
    }

    public List<DeliveryAttributeMapping> deliveryAttributeMappings() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryAttributeMappings();
    }

    public AzureFunctionEventSubscriptionDestination withDeliveryAttributeMappings(List<DeliveryAttributeMapping> deliveryAttributeMappings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFunctionEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withDeliveryAttributeMappings(deliveryAttributeMappings);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionEventSubscriptionDestination fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionEventSubscriptionDestination)jsonReader.readObject(reader -> {
            AzureFunctionEventSubscriptionDestination deserializedAzureFunctionEventSubscriptionDestination = new AzureFunctionEventSubscriptionDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedAzureFunctionEventSubscriptionDestination.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAzureFunctionEventSubscriptionDestination.innerProperties = AzureFunctionEventSubscriptionDestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFunctionEventSubscriptionDestination;
        });
    }
}

