/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.AzureADPartnerClientAuthenticationProperties;
import com.azure.resourcemanager.eventgrid.models.PartnerClientAuthentication;
import com.azure.resourcemanager.eventgrid.models.PartnerClientAuthenticationType;
import java.io.IOException;

public final class AzureADPartnerClientAuthentication
extends PartnerClientAuthentication {
    private PartnerClientAuthenticationType clientAuthenticationType = PartnerClientAuthenticationType.AZURE_AD;
    private AzureADPartnerClientAuthenticationProperties innerProperties;

    @Override
    public PartnerClientAuthenticationType clientAuthenticationType() {
        return this.clientAuthenticationType;
    }

    AzureADPartnerClientAuthenticationProperties innerProperties() {
        return this.innerProperties;
    }

    public String azureActiveDirectoryTenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().azureActiveDirectoryTenantId();
    }

    public AzureADPartnerClientAuthentication withAzureActiveDirectoryTenantId(String azureActiveDirectoryTenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureADPartnerClientAuthenticationProperties();
        }
        this.innerProperties().withAzureActiveDirectoryTenantId(azureActiveDirectoryTenantId);
        return this;
    }

    public String azureActiveDirectoryApplicationIdOrUri() {
        return this.innerProperties() == null ? null : this.innerProperties().azureActiveDirectoryApplicationIdOrUri();
    }

    public AzureADPartnerClientAuthentication withAzureActiveDirectoryApplicationIdOrUri(String azureActiveDirectoryApplicationIdOrUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureADPartnerClientAuthenticationProperties();
        }
        this.innerProperties().withAzureActiveDirectoryApplicationIdOrUri(azureActiveDirectoryApplicationIdOrUri);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientAuthenticationType", this.clientAuthenticationType == null ? null : this.clientAuthenticationType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AzureADPartnerClientAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (AzureADPartnerClientAuthentication)jsonReader.readObject(reader -> {
            AzureADPartnerClientAuthentication deserializedAzureADPartnerClientAuthentication = new AzureADPartnerClientAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientAuthenticationType".equals(fieldName)) {
                    deserializedAzureADPartnerClientAuthentication.clientAuthenticationType = PartnerClientAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAzureADPartnerClientAuthentication.innerProperties = AzureADPartnerClientAuthenticationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureADPartnerClientAuthentication;
        });
    }
}

