/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.TopicTypesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.EventTypeInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicTypeInfoInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.EventTypesListResult;
import com.azure.resourcemanager.eventgrid.models.TopicTypesListResult;
import reactor.core.publisher.Mono;

public final class TopicTypesClientImpl
implements TopicTypesClient {
    private final TopicTypesService service;
    private final EventGridManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(TopicTypesClientImpl.class);

    TopicTypesClientImpl(EventGridManagementClientImpl client) {
        this.service = (TopicTypesService)RestProxy.create(TopicTypesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicTypeInfoInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicTypesListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicTypeInfoInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TopicTypeInfoInner> listSinglePage() {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TopicTypesListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicTypesListResult)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TopicTypeInfoInner> listSinglePage(Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TopicTypesListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicTypesListResult)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicTypeInfoInner> list() {
        return new PagedIterable(() -> this.listSinglePage());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicTypeInfoInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TopicTypeInfoInner>> getWithResponseAsync(String topicTypeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), topicTypeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicTypeInfoInner> getAsync(String topicTypeName) {
        return this.getWithResponseAsync(topicTypeName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TopicTypeInfoInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicTypeInfoInner> getWithResponse(String topicTypeName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (topicTypeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), topicTypeName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicTypeInfoInner get(String topicTypeName) {
        return (TopicTypeInfoInner)((Object)this.getWithResponse(topicTypeName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventTypeInner>> listEventTypesSinglePageAsync(String topicTypeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listEventTypes(this.client.getEndpoint(), topicTypeName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventTypesListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventTypeInner> listEventTypesAsync(String topicTypeName) {
        return new PagedFlux(() -> this.listEventTypesSinglePageAsync(topicTypeName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<EventTypeInner> listEventTypesSinglePage(String topicTypeName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (topicTypeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<EventTypesListResult> res = this.service.listEventTypesSync(this.client.getEndpoint(), topicTypeName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventTypesListResult)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<EventTypeInner> listEventTypesSinglePage(String topicTypeName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (topicTypeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<EventTypesListResult> res = this.service.listEventTypesSync(this.client.getEndpoint(), topicTypeName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventTypesListResult)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventTypeInner> listEventTypes(String topicTypeName) {
        return new PagedIterable(() -> this.listEventTypesSinglePage(topicTypeName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventTypeInner> listEventTypes(String topicTypeName, Context context) {
        return new PagedIterable(() -> this.listEventTypesSinglePage(topicTypeName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementClientTopicTypes")
    public static interface TopicTypesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.EventGrid/topicTypes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicTypesListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.EventGrid/topicTypes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TopicTypesListResult> listSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicTypeInfoInner>> get(@HostParam(value="$host") String var1, @PathParam(value="topicTypeName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TopicTypeInfoInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="topicTypeName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventTypes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventTypesListResult>> listEventTypes(@HostParam(value="$host") String var1, @PathParam(value="topicTypeName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventTypes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<EventTypesListResult> listEventTypesSync(@HostParam(value="$host") String var1, @PathParam(value="topicTypeName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

