/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.TopicSpacesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSpaceInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.implementation.TopicSpaceImpl;
import com.azure.resourcemanager.eventgrid.models.TopicSpace;
import com.azure.resourcemanager.eventgrid.models.TopicSpaces;

public final class TopicSpacesImpl
implements TopicSpaces {
    private static final ClientLogger LOGGER = new ClientLogger(TopicSpacesImpl.class);
    private final TopicSpacesClient innerClient;
    private final EventGridManager serviceManager;

    public TopicSpacesImpl(TopicSpacesClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<TopicSpace> getWithResponse(String resourceGroupName, String namespaceName, String topicSpaceName, Context context) {
        Response<TopicSpaceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, topicSpaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TopicSpaceImpl((TopicSpaceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TopicSpace get(String resourceGroupName, String namespaceName, String topicSpaceName) {
        TopicSpaceInner inner = this.serviceClient().get(resourceGroupName, namespaceName, topicSpaceName);
        if (inner != null) {
            return new TopicSpaceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String topicSpaceName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, topicSpaceName);
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String topicSpaceName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, topicSpaceName, context);
    }

    @Override
    public PagedIterable<TopicSpace> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<TopicSpaceInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TopicSpaceImpl((TopicSpaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TopicSpace> listByNamespace(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        PagedIterable<TopicSpaceInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TopicSpaceImpl((TopicSpaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public TopicSpace getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicSpaceName = ResourceManagerUtils.getValueFromIdByName(id, "topicSpaces");
        if (topicSpaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topicSpaces'.", id)));
        }
        return (TopicSpace)this.getWithResponse(resourceGroupName, namespaceName, topicSpaceName, Context.NONE).getValue();
    }

    @Override
    public Response<TopicSpace> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicSpaceName = ResourceManagerUtils.getValueFromIdByName(id, "topicSpaces");
        if (topicSpaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topicSpaces'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, topicSpaceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicSpaceName = ResourceManagerUtils.getValueFromIdByName(id, "topicSpaces");
        if (topicSpaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topicSpaces'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, topicSpaceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicSpaceName = ResourceManagerUtils.getValueFromIdByName(id, "topicSpaces");
        if (topicSpaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topicSpaces'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, topicSpaceName, context);
    }

    private TopicSpacesClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public TopicSpaceImpl define(String name) {
        return new TopicSpaceImpl(name, this.manager());
    }
}

