/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.TopicSpacesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSpaceInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.TopicSpacesListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TopicSpacesClientImpl
implements TopicSpacesClient {
    private final TopicSpacesService service;
    private final EventGridManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(TopicSpacesClientImpl.class);

    TopicSpacesClientImpl(EventGridManagementClientImpl client) {
        this.service = (TopicSpacesService)RestProxy.create(TopicSpacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TopicSpaceInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicSpaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicSpaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicSpaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicSpaceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicSpaceInner> getAsync(String resourceGroupName, String namespaceName, String topicSpaceName) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, topicSpaceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TopicSpaceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicSpaceInner> getWithResponse(String resourceGroupName, String namespaceName, String topicSpaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicSpaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicSpaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicSpaceName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSpaceInner get(String resourceGroupName, String namespaceName, String topicSpaceName) {
        return (TopicSpaceInner)((Object)this.getWithResponse(resourceGroupName, namespaceName, topicSpaceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicSpaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicSpaceName is required and cannot be null."));
        }
        if (topicSpaceInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicSpaceInfo is required and cannot be null."));
        }
        topicSpaceInfo.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicSpaceName, this.client.getApiVersion(), topicSpaceInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicSpaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicSpaceName is required and cannot be null."));
        }
        if (topicSpaceInfo == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicSpaceInfo is required and cannot be null."));
        }
        topicSpaceInfo.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicSpaceName, this.client.getApiVersion(), topicSpaceInfo, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicSpaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicSpaceName is required and cannot be null."));
        }
        if (topicSpaceInfo == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicSpaceInfo is required and cannot be null."));
        }
        topicSpaceInfo.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicSpaceName, this.client.getApiVersion(), topicSpaceInfo, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicSpaceInner>, TopicSpaceInner> beginCreateOrUpdateAsync(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicSpaceName, topicSpaceInfo);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicSpaceInner.class), (Type)((Object)TopicSpaceInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicSpaceInner>, TopicSpaceInner> beginCreateOrUpdate(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, namespaceName, topicSpaceName, topicSpaceInfo);
        return this.client.getLroResult(response, (Type)((Object)TopicSpaceInner.class), (Type)((Object)TopicSpaceInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicSpaceInner>, TopicSpaceInner> beginCreateOrUpdate(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, namespaceName, topicSpaceName, topicSpaceInfo, context);
        return this.client.getLroResult(response, (Type)((Object)TopicSpaceInner.class), (Type)((Object)TopicSpaceInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicSpaceInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicSpaceName, topicSpaceInfo).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSpaceInner createOrUpdate(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo) {
        return (TopicSpaceInner)((Object)this.beginCreateOrUpdate(resourceGroupName, namespaceName, topicSpaceName, topicSpaceInfo).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSpaceInner createOrUpdate(String resourceGroupName, String namespaceName, String topicSpaceName, TopicSpaceInner topicSpaceInfo, Context context) {
        return (TopicSpaceInner)((Object)this.beginCreateOrUpdate(resourceGroupName, namespaceName, topicSpaceName, topicSpaceInfo, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicSpaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicSpaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicSpaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicSpaceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String namespaceName, String topicSpaceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicSpaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicSpaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicSpaceName, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String namespaceName, String topicSpaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicSpaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicSpaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicSpaceName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String namespaceName, String topicSpaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicSpaceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String namespaceName, String topicSpaceName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, namespaceName, topicSpaceName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String namespaceName, String topicSpaceName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, namespaceName, topicSpaceName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicSpaceName) {
        return this.beginDeleteAsync(resourceGroupName, namespaceName, topicSpaceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String topicSpaceName) {
        this.beginDelete(resourceGroupName, namespaceName, topicSpaceName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String topicSpaceName, Context context) {
        this.beginDelete(resourceGroupName, namespaceName, topicSpaceName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicSpaceInner>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNamespace(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicSpacesListResult)res.getValue()).value(), ((TopicSpacesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicSpaceInner> listByNamespaceAsync(String resourceGroupName, String namespaceName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, filter, top), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicSpaceInner> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, filter, top), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TopicSpaceInner> listByNamespaceSinglePage(String resourceGroupName, String namespaceName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TopicSpacesListResult> res = this.service.listByNamespaceSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), filter, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicSpacesListResult)res.getValue()).value(), ((TopicSpacesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TopicSpaceInner> listByNamespaceSinglePage(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TopicSpacesListResult> res = this.service.listByNamespaceSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), filter, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicSpacesListResult)res.getValue()).value(), ((TopicSpacesListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicSpaceInner> listByNamespace(String resourceGroupName, String namespaceName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(() -> this.listByNamespaceSinglePage(resourceGroupName, namespaceName, filter, top), nextLink -> this.listByNamespaceNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicSpaceInner> listByNamespace(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        return new PagedIterable(() -> this.listByNamespaceSinglePage(resourceGroupName, namespaceName, filter, top, context), nextLink -> this.listByNamespaceNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicSpaceInner>> listByNamespaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicSpacesListResult)res.getValue()).value(), ((TopicSpacesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TopicSpaceInner> listByNamespaceNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TopicSpacesListResult> res = this.service.listByNamespaceNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicSpacesListResult)res.getValue()).value(), ((TopicSpacesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TopicSpaceInner> listByNamespaceNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TopicSpacesListResult> res = this.service.listByNamespaceNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicSpacesListResult)res.getValue()).value(), ((TopicSpacesListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementClientTopicSpaces")
    public static interface TopicSpacesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces/{topicSpaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicSpaceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicSpaceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces/{topicSpaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TopicSpaceInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicSpaceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces/{topicSpaceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicSpaceName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") TopicSpaceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces/{topicSpaceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicSpaceName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") TopicSpaceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces/{topicSpaceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicSpaceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces/{topicSpaceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicSpaceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicSpacesListResult>> listByNamespace(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TopicSpacesListResult> listByNamespaceSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicSpacesListResult>> listByNamespaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TopicSpacesListResult> listByNamespaceNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

