/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSpaceInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.TopicSpace;
import com.azure.resourcemanager.eventgrid.models.TopicSpaceProvisioningState;
import java.util.Collections;
import java.util.List;

public final class TopicSpaceImpl
implements TopicSpace,
TopicSpace.Definition,
TopicSpace.Update {
    private TopicSpaceInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String namespaceName;
    private String topicSpaceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public List<String> topicTemplates() {
        List<String> inner = this.innerModel().topicTemplates();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public TopicSpaceProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TopicSpaceInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public TopicSpaceImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        return this;
    }

    @Override
    public TopicSpace create() {
        this.innerObject = this.serviceManager.serviceClient().getTopicSpaces().createOrUpdate(this.resourceGroupName, this.namespaceName, this.topicSpaceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public TopicSpace create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTopicSpaces().createOrUpdate(this.resourceGroupName, this.namespaceName, this.topicSpaceName, this.innerModel(), context);
        return this;
    }

    TopicSpaceImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new TopicSpaceInner();
        this.serviceManager = serviceManager;
        this.topicSpaceName = name;
    }

    @Override
    public TopicSpaceImpl update() {
        return this;
    }

    @Override
    public TopicSpace apply() {
        this.innerObject = this.serviceManager.serviceClient().getTopicSpaces().createOrUpdate(this.resourceGroupName, this.namespaceName, this.topicSpaceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public TopicSpace apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTopicSpaces().createOrUpdate(this.resourceGroupName, this.namespaceName, this.topicSpaceName, this.innerModel(), context);
        return this;
    }

    TopicSpaceImpl(TopicSpaceInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.namespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namespaces");
        this.topicSpaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "topicSpaces");
    }

    @Override
    public TopicSpace refresh() {
        this.innerObject = (TopicSpaceInner)((Object)this.serviceManager.serviceClient().getTopicSpaces().getWithResponse(this.resourceGroupName, this.namespaceName, this.topicSpaceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public TopicSpace refresh(Context context) {
        this.innerObject = (TopicSpaceInner)((Object)this.serviceManager.serviceClient().getTopicSpaces().getWithResponse(this.resourceGroupName, this.namespaceName, this.topicSpaceName, context).getValue());
        return this;
    }

    @Override
    public TopicSpaceImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public TopicSpaceImpl withTopicTemplates(List<String> topicTemplates) {
        this.innerModel().withTopicTemplates(topicTemplates);
        return this;
    }
}

