/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeListResult;
import com.azure.resourcemanager.eventgrid.models.DeliveryConfiguration;
import com.azure.resourcemanager.eventgrid.models.DeliverySchema;
import com.azure.resourcemanager.eventgrid.models.FiltersConfiguration;
import com.azure.resourcemanager.eventgrid.models.Subscription;
import com.azure.resourcemanager.eventgrid.models.SubscriptionFullUrl;
import com.azure.resourcemanager.eventgrid.models.SubscriptionProvisioningState;
import com.azure.resourcemanager.eventgrid.models.SubscriptionUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class SubscriptionImpl
implements Subscription,
Subscription.Definition,
Subscription.Update {
    private SubscriptionInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String namespaceName;
    private String topicName;
    private String eventSubscriptionName;
    private SubscriptionUpdateParameters updateEventSubscriptionUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SubscriptionProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public DeliveryConfiguration deliveryConfiguration() {
        return this.innerModel().deliveryConfiguration();
    }

    @Override
    public DeliverySchema eventDeliverySchema() {
        return this.innerModel().eventDeliverySchema();
    }

    @Override
    public FiltersConfiguration filtersConfiguration() {
        return this.innerModel().filtersConfiguration();
    }

    @Override
    public OffsetDateTime expirationTimeUtc() {
        return this.innerModel().expirationTimeUtc();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SubscriptionInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public SubscriptionImpl withExistingTopic(String resourceGroupName, String namespaceName, String topicName) {
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.topicName = topicName;
        return this;
    }

    @Override
    public Subscription create() {
        this.innerObject = this.serviceManager.serviceClient().getNamespaceTopicEventSubscriptions().createOrUpdate(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Subscription create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamespaceTopicEventSubscriptions().createOrUpdate(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName, this.innerModel(), context);
        return this;
    }

    SubscriptionImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new SubscriptionInner();
        this.serviceManager = serviceManager;
        this.eventSubscriptionName = name;
    }

    @Override
    public SubscriptionImpl update() {
        this.updateEventSubscriptionUpdateParameters = new SubscriptionUpdateParameters();
        return this;
    }

    @Override
    public Subscription apply() {
        this.innerObject = this.serviceManager.serviceClient().getNamespaceTopicEventSubscriptions().update(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName, this.updateEventSubscriptionUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public Subscription apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamespaceTopicEventSubscriptions().update(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName, this.updateEventSubscriptionUpdateParameters, context);
        return this;
    }

    SubscriptionImpl(SubscriptionInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.namespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namespaces");
        this.topicName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "topics");
        this.eventSubscriptionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "eventSubscriptions");
    }

    @Override
    public Subscription refresh() {
        this.innerObject = (SubscriptionInner)((Object)this.serviceManager.serviceClient().getNamespaceTopicEventSubscriptions().getWithResponse(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Subscription refresh(Context context) {
        this.innerObject = (SubscriptionInner)((Object)this.serviceManager.serviceClient().getNamespaceTopicEventSubscriptions().getWithResponse(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName, context).getValue());
        return this;
    }

    @Override
    public Response<DeliveryAttributeListResult> getDeliveryAttributesWithResponse(Context context) {
        return this.serviceManager.namespaceTopicEventSubscriptions().getDeliveryAttributesWithResponse(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName, context);
    }

    @Override
    public DeliveryAttributeListResult getDeliveryAttributes() {
        return this.serviceManager.namespaceTopicEventSubscriptions().getDeliveryAttributes(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName);
    }

    @Override
    public Response<SubscriptionFullUrl> getFullUrlWithResponse(Context context) {
        return this.serviceManager.namespaceTopicEventSubscriptions().getFullUrlWithResponse(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName, context);
    }

    @Override
    public SubscriptionFullUrl getFullUrl() {
        return this.serviceManager.namespaceTopicEventSubscriptions().getFullUrl(this.resourceGroupName, this.namespaceName, this.topicName, this.eventSubscriptionName);
    }

    @Override
    public SubscriptionImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public SubscriptionImpl withDeliveryConfiguration(DeliveryConfiguration deliveryConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withDeliveryConfiguration(deliveryConfiguration);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withDeliveryConfiguration(deliveryConfiguration);
        return this;
    }

    @Override
    public SubscriptionImpl withEventDeliverySchema(DeliverySchema eventDeliverySchema) {
        if (this.isInCreateMode()) {
            this.innerModel().withEventDeliverySchema(eventDeliverySchema);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withEventDeliverySchema(eventDeliverySchema);
        return this;
    }

    @Override
    public SubscriptionImpl withFiltersConfiguration(FiltersConfiguration filtersConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withFiltersConfiguration(filtersConfiguration);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withFiltersConfiguration(filtersConfiguration);
        return this;
    }

    @Override
    public SubscriptionImpl withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        if (this.isInCreateMode()) {
            this.innerModel().withExpirationTimeUtc(expirationTimeUtc);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withExpirationTimeUtc(expirationTimeUtc);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

