/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerTopicInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopic;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public final class PartnerTopicImpl
implements PartnerTopic,
PartnerTopic.Definition,
PartnerTopic.Update {
    private PartnerTopicInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String partnerTopicName;
    private PartnerTopicUpdateParameters updatePartnerTopicUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public IdentityInfo identity() {
        return this.innerModel().identity();
    }

    @Override
    public UUID partnerRegistrationImmutableId() {
        return this.innerModel().partnerRegistrationImmutableId();
    }

    @Override
    public String source() {
        return this.innerModel().source();
    }

    @Override
    public EventTypeInfo eventTypeInfo() {
        return this.innerModel().eventTypeInfo();
    }

    @Override
    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.innerModel().expirationTimeIfNotActivatedUtc();
    }

    @Override
    public PartnerTopicProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public PartnerTopicActivationState activationState() {
        return this.innerModel().activationState();
    }

    @Override
    public String partnerTopicFriendlyDescription() {
        return this.innerModel().partnerTopicFriendlyDescription();
    }

    @Override
    public String messageForActivation() {
        return this.innerModel().messageForActivation();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PartnerTopicInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public PartnerTopicImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public PartnerTopic create() {
        this.innerObject = (PartnerTopicInner)((Object)this.serviceManager.serviceClient().getPartnerTopics().createOrUpdateWithResponse(this.resourceGroupName, this.partnerTopicName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public PartnerTopic create(Context context) {
        this.innerObject = (PartnerTopicInner)((Object)this.serviceManager.serviceClient().getPartnerTopics().createOrUpdateWithResponse(this.resourceGroupName, this.partnerTopicName, this.innerModel(), context).getValue());
        return this;
    }

    PartnerTopicImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new PartnerTopicInner();
        this.serviceManager = serviceManager;
        this.partnerTopicName = name;
    }

    @Override
    public PartnerTopicImpl update() {
        this.updatePartnerTopicUpdateParameters = new PartnerTopicUpdateParameters();
        return this;
    }

    @Override
    public PartnerTopic apply() {
        this.innerObject = (PartnerTopicInner)((Object)this.serviceManager.serviceClient().getPartnerTopics().updateWithResponse(this.resourceGroupName, this.partnerTopicName, this.updatePartnerTopicUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public PartnerTopic apply(Context context) {
        this.innerObject = (PartnerTopicInner)((Object)this.serviceManager.serviceClient().getPartnerTopics().updateWithResponse(this.resourceGroupName, this.partnerTopicName, this.updatePartnerTopicUpdateParameters, context).getValue());
        return this;
    }

    PartnerTopicImpl(PartnerTopicInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.partnerTopicName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "partnerTopics");
    }

    @Override
    public PartnerTopic refresh() {
        this.innerObject = (PartnerTopicInner)((Object)this.serviceManager.serviceClient().getPartnerTopics().getByResourceGroupWithResponse(this.resourceGroupName, this.partnerTopicName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PartnerTopic refresh(Context context) {
        this.innerObject = (PartnerTopicInner)((Object)this.serviceManager.serviceClient().getPartnerTopics().getByResourceGroupWithResponse(this.resourceGroupName, this.partnerTopicName, context).getValue());
        return this;
    }

    @Override
    public Response<PartnerTopic> activateWithResponse(Context context) {
        return this.serviceManager.partnerTopics().activateWithResponse(this.resourceGroupName, this.partnerTopicName, context);
    }

    @Override
    public PartnerTopic activate() {
        return this.serviceManager.partnerTopics().activate(this.resourceGroupName, this.partnerTopicName);
    }

    @Override
    public Response<PartnerTopic> deactivateWithResponse(Context context) {
        return this.serviceManager.partnerTopics().deactivateWithResponse(this.resourceGroupName, this.partnerTopicName, context);
    }

    @Override
    public PartnerTopic deactivate() {
        return this.serviceManager.partnerTopics().deactivate(this.resourceGroupName, this.partnerTopicName);
    }

    @Override
    public PartnerTopicImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public PartnerTopicImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public PartnerTopicImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updatePartnerTopicUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public PartnerTopicImpl withIdentity(IdentityInfo identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updatePartnerTopicUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public PartnerTopicImpl withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.innerModel().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    @Override
    public PartnerTopicImpl withSource(String source) {
        this.innerModel().withSource(source);
        return this;
    }

    @Override
    public PartnerTopicImpl withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.innerModel().withEventTypeInfo(eventTypeInfo);
        return this;
    }

    @Override
    public PartnerTopicImpl withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.innerModel().withExpirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc);
        return this;
    }

    @Override
    public PartnerTopicImpl withActivationState(PartnerTopicActivationState activationState) {
        this.innerModel().withActivationState(activationState);
        return this;
    }

    @Override
    public PartnerTopicImpl withPartnerTopicFriendlyDescription(String partnerTopicFriendlyDescription) {
        this.innerModel().withPartnerTopicFriendlyDescription(partnerTopicFriendlyDescription);
        return this;
    }

    @Override
    public PartnerTopicImpl withMessageForActivation(String messageForActivation) {
        this.innerModel().withMessageForActivation(messageForActivation);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

