/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerNamespaceInner;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespace;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaceProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaceRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaceSharedAccessKeys;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaceUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicRoutingMode;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnection;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class PartnerNamespaceImpl
implements PartnerNamespace,
PartnerNamespace.Definition,
PartnerNamespace.Update {
    private PartnerNamespaceInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String partnerNamespaceName;
    private PartnerNamespaceUpdateParameters updatePartnerNamespaceUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public PartnerNamespaceProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String partnerRegistrationFullyQualifiedId() {
        return this.innerModel().partnerRegistrationFullyQualifiedId();
    }

    @Override
    public TlsVersion minimumTlsVersionAllowed() {
        return this.innerModel().minimumTlsVersionAllowed();
    }

    @Override
    public String endpoint() {
        return this.innerModel().endpoint();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public List<InboundIpRule> inboundIpRules() {
        List<InboundIpRule> inner = this.innerModel().inboundIpRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean disableLocalAuth() {
        return this.innerModel().disableLocalAuth();
    }

    @Override
    public PartnerTopicRoutingMode partnerTopicRoutingMode() {
        return this.innerModel().partnerTopicRoutingMode();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PartnerNamespaceInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public PartnerNamespaceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public PartnerNamespace create() {
        this.innerObject = this.serviceManager.serviceClient().getPartnerNamespaces().createOrUpdate(this.resourceGroupName, this.partnerNamespaceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PartnerNamespace create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPartnerNamespaces().createOrUpdate(this.resourceGroupName, this.partnerNamespaceName, this.innerModel(), context);
        return this;
    }

    PartnerNamespaceImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new PartnerNamespaceInner();
        this.serviceManager = serviceManager;
        this.partnerNamespaceName = name;
    }

    @Override
    public PartnerNamespaceImpl update() {
        this.updatePartnerNamespaceUpdateParameters = new PartnerNamespaceUpdateParameters();
        return this;
    }

    @Override
    public PartnerNamespace apply() {
        this.innerObject = this.serviceManager.serviceClient().getPartnerNamespaces().update(this.resourceGroupName, this.partnerNamespaceName, this.updatePartnerNamespaceUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public PartnerNamespace apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPartnerNamespaces().update(this.resourceGroupName, this.partnerNamespaceName, this.updatePartnerNamespaceUpdateParameters, context);
        return this;
    }

    PartnerNamespaceImpl(PartnerNamespaceInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.partnerNamespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "partnerNamespaces");
    }

    @Override
    public PartnerNamespace refresh() {
        this.innerObject = (PartnerNamespaceInner)((Object)this.serviceManager.serviceClient().getPartnerNamespaces().getByResourceGroupWithResponse(this.resourceGroupName, this.partnerNamespaceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PartnerNamespace refresh(Context context) {
        this.innerObject = (PartnerNamespaceInner)((Object)this.serviceManager.serviceClient().getPartnerNamespaces().getByResourceGroupWithResponse(this.resourceGroupName, this.partnerNamespaceName, context).getValue());
        return this;
    }

    @Override
    public Response<PartnerNamespaceSharedAccessKeys> listSharedAccessKeysWithResponse(Context context) {
        return this.serviceManager.partnerNamespaces().listSharedAccessKeysWithResponse(this.resourceGroupName, this.partnerNamespaceName, context);
    }

    @Override
    public PartnerNamespaceSharedAccessKeys listSharedAccessKeys() {
        return this.serviceManager.partnerNamespaces().listSharedAccessKeys(this.resourceGroupName, this.partnerNamespaceName);
    }

    @Override
    public Response<PartnerNamespaceSharedAccessKeys> regenerateKeyWithResponse(PartnerNamespaceRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.serviceManager.partnerNamespaces().regenerateKeyWithResponse(this.resourceGroupName, this.partnerNamespaceName, regenerateKeyRequest, context);
    }

    @Override
    public PartnerNamespaceSharedAccessKeys regenerateKey(PartnerNamespaceRegenerateKeyRequest regenerateKeyRequest) {
        return this.serviceManager.partnerNamespaces().regenerateKey(this.resourceGroupName, this.partnerNamespaceName, regenerateKeyRequest);
    }

    @Override
    public PartnerNamespaceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public PartnerNamespaceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public PartnerNamespaceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updatePartnerNamespaceUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public PartnerNamespaceImpl withPartnerRegistrationFullyQualifiedId(String partnerRegistrationFullyQualifiedId) {
        this.innerModel().withPartnerRegistrationFullyQualifiedId(partnerRegistrationFullyQualifiedId);
        return this;
    }

    @Override
    public PartnerNamespaceImpl withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        if (this.isInCreateMode()) {
            this.innerModel().withMinimumTlsVersionAllowed(minimumTlsVersionAllowed);
            return this;
        }
        this.updatePartnerNamespaceUpdateParameters.withMinimumTlsVersionAllowed(minimumTlsVersionAllowed);
        return this;
    }

    @Override
    public PartnerNamespaceImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updatePartnerNamespaceUpdateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public PartnerNamespaceImpl withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.isInCreateMode()) {
            this.innerModel().withInboundIpRules(inboundIpRules);
            return this;
        }
        this.updatePartnerNamespaceUpdateParameters.withInboundIpRules(inboundIpRules);
        return this;
    }

    @Override
    public PartnerNamespaceImpl withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisableLocalAuth(disableLocalAuth);
            return this;
        }
        this.updatePartnerNamespaceUpdateParameters.withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    @Override
    public PartnerNamespaceImpl withPartnerTopicRoutingMode(PartnerTopicRoutingMode partnerTopicRoutingMode) {
        this.innerModel().withPartnerTopicRoutingMode(partnerTopicRoutingMode);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

