/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.PartnerDestinationsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerDestinationInner;
import com.azure.resourcemanager.eventgrid.implementation.PartnerDestinationImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.PartnerDestination;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinations;

public final class PartnerDestinationsImpl
implements PartnerDestinations {
    private static final ClientLogger LOGGER = new ClientLogger(PartnerDestinationsImpl.class);
    private final PartnerDestinationsClient innerClient;
    private final EventGridManager serviceManager;

    public PartnerDestinationsImpl(PartnerDestinationsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PartnerDestination> getByResourceGroupWithResponse(String resourceGroupName, String partnerDestinationName, Context context) {
        Response<PartnerDestinationInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, partnerDestinationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerDestinationImpl((PartnerDestinationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerDestination getByResourceGroup(String resourceGroupName, String partnerDestinationName) {
        PartnerDestinationInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, partnerDestinationName);
        if (inner != null) {
            return new PartnerDestinationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String partnerDestinationName) {
        this.serviceClient().delete(resourceGroupName, partnerDestinationName);
    }

    @Override
    public void delete(String resourceGroupName, String partnerDestinationName, Context context) {
        this.serviceClient().delete(resourceGroupName, partnerDestinationName, context);
    }

    @Override
    public PagedIterable<PartnerDestination> list() {
        PagedIterable<PartnerDestinationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerDestinationImpl((PartnerDestinationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerDestination> list(String filter, Integer top, Context context) {
        PagedIterable<PartnerDestinationInner> inner = this.serviceClient().list(filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerDestinationImpl((PartnerDestinationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerDestination> listByResourceGroup(String resourceGroupName) {
        PagedIterable<PartnerDestinationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerDestinationImpl((PartnerDestinationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerDestination> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        PagedIterable<PartnerDestinationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerDestinationImpl((PartnerDestinationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<PartnerDestination> activateWithResponse(String resourceGroupName, String partnerDestinationName, Context context) {
        Response<PartnerDestinationInner> inner = this.serviceClient().activateWithResponse(resourceGroupName, partnerDestinationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerDestinationImpl((PartnerDestinationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerDestination activate(String resourceGroupName, String partnerDestinationName) {
        PartnerDestinationInner inner = this.serviceClient().activate(resourceGroupName, partnerDestinationName);
        if (inner != null) {
            return new PartnerDestinationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PartnerDestination getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerDestinationName = ResourceManagerUtils.getValueFromIdByName(id, "partnerDestinations");
        if (partnerDestinationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerDestinations'.", id)));
        }
        return (PartnerDestination)this.getByResourceGroupWithResponse(resourceGroupName, partnerDestinationName, Context.NONE).getValue();
    }

    @Override
    public Response<PartnerDestination> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerDestinationName = ResourceManagerUtils.getValueFromIdByName(id, "partnerDestinations");
        if (partnerDestinationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerDestinations'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, partnerDestinationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerDestinationName = ResourceManagerUtils.getValueFromIdByName(id, "partnerDestinations");
        if (partnerDestinationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerDestinations'.", id)));
        }
        this.delete(resourceGroupName, partnerDestinationName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerDestinationName = ResourceManagerUtils.getValueFromIdByName(id, "partnerDestinations");
        if (partnerDestinationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerDestinations'.", id)));
        }
        this.delete(resourceGroupName, partnerDestinationName, context);
    }

    private PartnerDestinationsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public PartnerDestinationImpl define(String name) {
        return new PartnerDestinationImpl(name, this.manager());
    }
}

