/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.PartnerConfigurationsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerConfigurationInner;
import com.azure.resourcemanager.eventgrid.implementation.PartnerConfigurationImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.Partner;
import com.azure.resourcemanager.eventgrid.models.PartnerConfiguration;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurationUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurations;

public final class PartnerConfigurationsImpl
implements PartnerConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(PartnerConfigurationsImpl.class);
    private final PartnerConfigurationsClient innerClient;
    private final EventGridManager serviceManager;

    public PartnerConfigurationsImpl(PartnerConfigurationsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PartnerConfiguration> getByResourceGroupWithResponse(String resourceGroupName, Context context) {
        Response<PartnerConfigurationInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerConfigurationImpl((PartnerConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerConfiguration getByResourceGroup(String resourceGroupName) {
        PartnerConfigurationInner inner = this.serviceClient().getByResourceGroup(resourceGroupName);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PartnerConfiguration createOrUpdate(String resourceGroupName, PartnerConfigurationInner partnerConfigurationInfo) {
        PartnerConfigurationInner inner = this.serviceClient().createOrUpdate(resourceGroupName, partnerConfigurationInfo);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PartnerConfiguration createOrUpdate(String resourceGroupName, PartnerConfigurationInner partnerConfigurationInfo, Context context) {
        PartnerConfigurationInner inner = this.serviceClient().createOrUpdate(resourceGroupName, partnerConfigurationInfo, context);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName) {
        this.serviceClient().delete(resourceGroupName);
    }

    @Override
    public void delete(String resourceGroupName, Context context) {
        this.serviceClient().delete(resourceGroupName, context);
    }

    @Override
    public PartnerConfiguration update(String resourceGroupName, PartnerConfigurationUpdateParameters partnerConfigurationUpdateParameters) {
        PartnerConfigurationInner inner = this.serviceClient().update(resourceGroupName, partnerConfigurationUpdateParameters);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PartnerConfiguration update(String resourceGroupName, PartnerConfigurationUpdateParameters partnerConfigurationUpdateParameters, Context context) {
        PartnerConfigurationInner inner = this.serviceClient().update(resourceGroupName, partnerConfigurationUpdateParameters, context);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PartnerConfiguration> listByResourceGroup(String resourceGroupName) {
        PagedIterable<PartnerConfigurationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerConfigurationImpl((PartnerConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerConfiguration> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<PartnerConfigurationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerConfigurationImpl((PartnerConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerConfiguration> list() {
        PagedIterable<PartnerConfigurationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerConfigurationImpl((PartnerConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerConfiguration> list(String filter, Integer top, Context context) {
        PagedIterable<PartnerConfigurationInner> inner = this.serviceClient().list(filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerConfigurationImpl((PartnerConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<PartnerConfiguration> authorizePartnerWithResponse(String resourceGroupName, Partner partnerInfo, Context context) {
        Response<PartnerConfigurationInner> inner = this.serviceClient().authorizePartnerWithResponse(resourceGroupName, partnerInfo, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerConfigurationImpl((PartnerConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerConfiguration authorizePartner(String resourceGroupName, Partner partnerInfo) {
        PartnerConfigurationInner inner = this.serviceClient().authorizePartner(resourceGroupName, partnerInfo);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PartnerConfiguration> unauthorizePartnerWithResponse(String resourceGroupName, Partner partnerInfo, Context context) {
        Response<PartnerConfigurationInner> inner = this.serviceClient().unauthorizePartnerWithResponse(resourceGroupName, partnerInfo, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerConfigurationImpl((PartnerConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerConfiguration unauthorizePartner(String resourceGroupName, Partner partnerInfo) {
        PartnerConfigurationInner inner = this.serviceClient().unauthorizePartner(resourceGroupName, partnerInfo);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    private PartnerConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

