/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.NetworkSecurityPerimeterConfigurationsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurationList;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterResourceType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NetworkSecurityPerimeterConfigurationsClientImpl
implements NetworkSecurityPerimeterConfigurationsClient {
    private final NetworkSecurityPerimeterConfigurationsService service;
    private final EventGridManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkSecurityPerimeterConfigurationsClientImpl.class);

    NetworkSecurityPerimeterConfigurationsClientImpl(EventGridManagementClientImpl client) {
        this.service = (NetworkSecurityPerimeterConfigurationsService)RestProxy.create(NetworkSecurityPerimeterConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkSecurityPerimeterConfigurationInner>> getWithResponseAsync(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (perimeterGuid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter perimeterGuid is required and cannot be null."));
        }
        if (associationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NetworkSecurityPerimeterConfigurationInner> getAsync(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        return this.getWithResponseAsync(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NetworkSecurityPerimeterConfigurationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkSecurityPerimeterConfigurationInner> getWithResponse(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (perimeterGuid == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter perimeterGuid is required and cannot be null."));
        }
        if (associationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkSecurityPerimeterConfigurationInner get(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        return (NetworkSecurityPerimeterConfigurationInner)((Object)this.getWithResponse(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reconcileWithResponseAsync(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (perimeterGuid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter perimeterGuid is required and cannot be null."));
        }
        if (associationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reconcile(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> reconcileWithResponse(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (perimeterGuid == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter perimeterGuid is required and cannot be null."));
        }
        if (associationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.reconcileSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> reconcileWithResponse(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (perimeterGuid == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter perimeterGuid is required and cannot be null."));
        }
        if (associationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.reconcileSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NetworkSecurityPerimeterConfigurationInner>, NetworkSecurityPerimeterConfigurationInner> beginReconcileAsync(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reconcileWithResponseAsync(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NetworkSecurityPerimeterConfigurationInner.class), (Type)((Object)NetworkSecurityPerimeterConfigurationInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NetworkSecurityPerimeterConfigurationInner>, NetworkSecurityPerimeterConfigurationInner> beginReconcile(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        Response<BinaryData> response = this.reconcileWithResponse(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName);
        return this.client.getLroResult(response, (Type)((Object)NetworkSecurityPerimeterConfigurationInner.class), (Type)((Object)NetworkSecurityPerimeterConfigurationInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NetworkSecurityPerimeterConfigurationInner>, NetworkSecurityPerimeterConfigurationInner> beginReconcile(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName, Context context) {
        Response<BinaryData> response = this.reconcileWithResponse(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, context);
        return this.client.getLroResult(response, (Type)((Object)NetworkSecurityPerimeterConfigurationInner.class), (Type)((Object)NetworkSecurityPerimeterConfigurationInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NetworkSecurityPerimeterConfigurationInner> reconcileAsync(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        return this.beginReconcileAsync(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkSecurityPerimeterConfigurationInner reconcile(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        return (NetworkSecurityPerimeterConfigurationInner)((Object)this.beginReconcile(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkSecurityPerimeterConfigurationInner reconcile(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName, Context context) {
        return (NetworkSecurityPerimeterConfigurationInner)((Object)this.beginReconcile(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>> listSinglePageAsync(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceType, resourceName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterConfigurationList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NetworkSecurityPerimeterConfigurationInner> listAsync(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceType, resourceName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NetworkSecurityPerimeterConfigurationInner> listSinglePage(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NetworkSecurityPerimeterConfigurationList> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceType, resourceName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterConfigurationList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NetworkSecurityPerimeterConfigurationInner> listSinglePage(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NetworkSecurityPerimeterConfigurationList> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceType, resourceName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterConfigurationList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterConfigurationInner> list(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, resourceType, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterConfigurationInner> list(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, resourceType, resourceName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementClientNetworkSecurityPerimeterConfigurations")
    public static interface NetworkSecurityPerimeterConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{resourceType}/{resourceName}/networkSecurityPerimeterConfigurations/{perimeterGuid}.{associationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterConfigurationInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceType") NetworkSecurityPerimeterResourceType var4, @PathParam(value="resourceName") String var5, @PathParam(value="perimeterGuid") String var6, @PathParam(value="associationName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{resourceType}/{resourceName}/networkSecurityPerimeterConfigurations/{perimeterGuid}.{associationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NetworkSecurityPerimeterConfigurationInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceType") NetworkSecurityPerimeterResourceType var4, @PathParam(value="resourceName") String var5, @PathParam(value="perimeterGuid") String var6, @PathParam(value="associationName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{resourceType}/{resourceName}/networkSecurityPerimeterConfigurations/{perimeterGuid}.{associationName}/reconcile")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reconcile(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceType") NetworkSecurityPerimeterResourceType var4, @PathParam(value="resourceName") String var5, @PathParam(value="perimeterGuid") String var6, @PathParam(value="associationName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{resourceType}/{resourceName}/networkSecurityPerimeterConfigurations/{perimeterGuid}.{associationName}/reconcile")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> reconcileSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceType") NetworkSecurityPerimeterResourceType var4, @PathParam(value="resourceName") String var5, @PathParam(value="perimeterGuid") String var6, @PathParam(value="associationName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{resourceType}/{resourceName}/networkSecurityPerimeterConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterConfigurationList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceType") NetworkSecurityPerimeterResourceType var4, @PathParam(value="resourceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{resourceType}/{resourceName}/networkSecurityPerimeterConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NetworkSecurityPerimeterConfigurationList> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceType") NetworkSecurityPerimeterResourceType var4, @PathParam(value="resourceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

