/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.NamespacesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.CustomDomainOwnershipValidationResultInner;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceInner;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceSharedAccessKeysInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.NamespaceRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.NamespaceUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.NamespacesListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NamespacesClientImpl
implements NamespacesClient {
    private final NamespacesService service;
    private final EventGridManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(NamespacesClientImpl.class);

    NamespacesClientImpl(EventGridManagementClientImpl client) {
        this.service = (NamespacesService)RestProxy.create(NamespacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NamespaceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String namespaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceInner> getByResourceGroupAsync(String resourceGroupName, String namespaceName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, namespaceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NamespaceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NamespaceInner> getByResourceGroupWithResponse(String resourceGroupName, String namespaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceInner getByResourceGroup(String resourceGroupName, String namespaceName) {
        return (NamespaceInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, namespaceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (namespaceInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceInfo is required and cannot be null."));
        }
        namespaceInfo.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), namespaceInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (namespaceInfo == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceInfo is required and cannot be null."));
        }
        namespaceInfo.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), namespaceInfo, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (namespaceInfo == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceInfo is required and cannot be null."));
        }
        namespaceInfo.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), namespaceInfo, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamespaceInner>, NamespaceInner> beginCreateOrUpdateAsync(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, namespaceInfo);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamespaceInner.class), (Type)((Object)NamespaceInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceInner>, NamespaceInner> beginCreateOrUpdate(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, namespaceName, namespaceInfo);
        return this.client.getLroResult(response, (Type)((Object)NamespaceInner.class), (Type)((Object)NamespaceInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceInner>, NamespaceInner> beginCreateOrUpdate(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, namespaceName, namespaceInfo, context);
        return this.client.getLroResult(response, (Type)((Object)NamespaceInner.class), (Type)((Object)NamespaceInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, namespaceName, namespaceInfo).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceInner createOrUpdate(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo) {
        return (NamespaceInner)((Object)this.beginCreateOrUpdate(resourceGroupName, namespaceName, namespaceInfo).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceInner createOrUpdate(String resourceGroupName, String namespaceName, NamespaceInner namespaceInfo, Context context) {
        return (NamespaceInner)((Object)this.beginCreateOrUpdate(resourceGroupName, namespaceName, namespaceInfo, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String namespaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String namespaceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String namespaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String namespaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, namespaceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String namespaceName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, namespaceName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String namespaceName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, namespaceName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String namespaceName) {
        return this.beginDeleteAsync(resourceGroupName, namespaceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName) {
        this.beginDelete(resourceGroupName, namespaceName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, Context context) {
        this.beginDelete(resourceGroupName, namespaceName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (namespaceUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceUpdateParameters is required and cannot be null."));
        }
        namespaceUpdateParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), namespaceUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (namespaceUpdateParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceUpdateParameters is required and cannot be null."));
        }
        namespaceUpdateParameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), namespaceUpdateParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (namespaceUpdateParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceUpdateParameters is required and cannot be null."));
        }
        namespaceUpdateParameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), namespaceUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamespaceInner>, NamespaceInner> beginUpdateAsync(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, namespaceName, namespaceUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamespaceInner.class), (Type)((Object)NamespaceInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceInner>, NamespaceInner> beginUpdate(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, namespaceName, namespaceUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)NamespaceInner.class), (Type)((Object)NamespaceInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceInner>, NamespaceInner> beginUpdate(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, namespaceName, namespaceUpdateParameters, context);
        return this.client.getLroResult(response, (Type)((Object)NamespaceInner.class), (Type)((Object)NamespaceInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceInner> updateAsync(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, namespaceName, namespaceUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceInner update(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters) {
        return (NamespaceInner)((Object)this.beginUpdate(resourceGroupName, namespaceName, namespaceUpdateParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceInner update(String resourceGroupName, String namespaceName, NamespaceUpdateParameters namespaceUpdateParameters, Context context) {
        return (NamespaceInner)((Object)this.beginUpdate(resourceGroupName, namespaceName, namespaceUpdateParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamespaceInner>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamespaceInner> listAsync(String filter, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamespaceInner> listAsync() {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NamespaceInner> listSinglePage(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NamespacesListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), filter, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NamespaceInner> listSinglePage(String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NamespacesListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), filter, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NamespaceInner> list() {
        String filter = null;
        Integer top = null;
        return new PagedIterable(() -> this.listSinglePage(filter, top), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NamespaceInner> list(String filter, Integer top, Context context) {
        return new PagedIterable(() -> this.listSinglePage(filter, top, context), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamespaceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamespaceInner> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamespaceInner> listByResourceGroupAsync(String resourceGroupName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NamespaceInner> listByResourceGroupSinglePage(String resourceGroupName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NamespacesListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), filter, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NamespaceInner> listByResourceGroupSinglePage(String resourceGroupName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NamespacesListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), filter, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NamespaceInner> listByResourceGroup(String resourceGroupName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, filter, top), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NamespaceInner> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, filter, top, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NamespaceSharedAccessKeysInner>> listSharedAccessKeysWithResponseAsync(String resourceGroupName, String namespaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSharedAccessKeys(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceSharedAccessKeysInner> listSharedAccessKeysAsync(String resourceGroupName, String namespaceName) {
        return this.listSharedAccessKeysWithResponseAsync(resourceGroupName, namespaceName).flatMap(res -> Mono.justOrEmpty((Object)((NamespaceSharedAccessKeysInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NamespaceSharedAccessKeysInner> listSharedAccessKeysWithResponse(String resourceGroupName, String namespaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.listSharedAccessKeysSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceSharedAccessKeysInner listSharedAccessKeys(String resourceGroupName, String namespaceName) {
        return (NamespaceSharedAccessKeysInner)this.listSharedAccessKeysWithResponse(resourceGroupName, namespaceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> regenerateKeyWithResponseAsync(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (regenerateKeyRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regenerateKeyRequest is required and cannot be null."));
        }
        regenerateKeyRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), regenerateKeyRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> regenerateKeyWithResponse(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (regenerateKeyRequest == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter regenerateKeyRequest is required and cannot be null."));
        }
        regenerateKeyRequest.validate();
        String accept = "application/json";
        return this.service.regenerateKeySync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), regenerateKeyRequest, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> regenerateKeyWithResponse(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (regenerateKeyRequest == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter regenerateKeyRequest is required and cannot be null."));
        }
        regenerateKeyRequest.validate();
        String accept = "application/json";
        return this.service.regenerateKeySync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), regenerateKeyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamespaceSharedAccessKeysInner>, NamespaceSharedAccessKeysInner> beginRegenerateKeyAsync(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.regenerateKeyWithResponseAsync(resourceGroupName, namespaceName, regenerateKeyRequest);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamespaceSharedAccessKeysInner.class), (Type)((Object)NamespaceSharedAccessKeysInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceSharedAccessKeysInner>, NamespaceSharedAccessKeysInner> beginRegenerateKey(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest) {
        Response<BinaryData> response = this.regenerateKeyWithResponse(resourceGroupName, namespaceName, regenerateKeyRequest);
        return this.client.getLroResult(response, (Type)((Object)NamespaceSharedAccessKeysInner.class), (Type)((Object)NamespaceSharedAccessKeysInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceSharedAccessKeysInner>, NamespaceSharedAccessKeysInner> beginRegenerateKey(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest, Context context) {
        Response<BinaryData> response = this.regenerateKeyWithResponse(resourceGroupName, namespaceName, regenerateKeyRequest, context);
        return this.client.getLroResult(response, (Type)((Object)NamespaceSharedAccessKeysInner.class), (Type)((Object)NamespaceSharedAccessKeysInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceSharedAccessKeysInner> regenerateKeyAsync(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest) {
        return this.beginRegenerateKeyAsync(resourceGroupName, namespaceName, regenerateKeyRequest).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceSharedAccessKeysInner regenerateKey(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest) {
        return (NamespaceSharedAccessKeysInner)this.beginRegenerateKey(resourceGroupName, namespaceName, regenerateKeyRequest).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceSharedAccessKeysInner regenerateKey(String resourceGroupName, String namespaceName, NamespaceRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return (NamespaceSharedAccessKeysInner)this.beginRegenerateKey(resourceGroupName, namespaceName, regenerateKeyRequest, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateCustomDomainOwnershipWithResponseAsync(String resourceGroupName, String namespaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateCustomDomainOwnership(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateCustomDomainOwnershipWithResponse(String resourceGroupName, String namespaceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.validateCustomDomainOwnershipSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateCustomDomainOwnershipWithResponse(String resourceGroupName, String namespaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.validateCustomDomainOwnershipSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomDomainOwnershipValidationResultInner>, CustomDomainOwnershipValidationResultInner> beginValidateCustomDomainOwnershipAsync(String resourceGroupName, String namespaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateCustomDomainOwnershipWithResponseAsync(resourceGroupName, namespaceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainOwnershipValidationResultInner.class), (Type)((Object)CustomDomainOwnershipValidationResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainOwnershipValidationResultInner>, CustomDomainOwnershipValidationResultInner> beginValidateCustomDomainOwnership(String resourceGroupName, String namespaceName) {
        Response<BinaryData> response = this.validateCustomDomainOwnershipWithResponse(resourceGroupName, namespaceName);
        return this.client.getLroResult(response, (Type)((Object)CustomDomainOwnershipValidationResultInner.class), (Type)((Object)CustomDomainOwnershipValidationResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainOwnershipValidationResultInner>, CustomDomainOwnershipValidationResultInner> beginValidateCustomDomainOwnership(String resourceGroupName, String namespaceName, Context context) {
        Response<BinaryData> response = this.validateCustomDomainOwnershipWithResponse(resourceGroupName, namespaceName, context);
        return this.client.getLroResult(response, (Type)((Object)CustomDomainOwnershipValidationResultInner.class), (Type)((Object)CustomDomainOwnershipValidationResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomDomainOwnershipValidationResultInner> validateCustomDomainOwnershipAsync(String resourceGroupName, String namespaceName) {
        return this.beginValidateCustomDomainOwnershipAsync(resourceGroupName, namespaceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainOwnershipValidationResultInner validateCustomDomainOwnership(String resourceGroupName, String namespaceName) {
        return (CustomDomainOwnershipValidationResultInner)this.beginValidateCustomDomainOwnership(resourceGroupName, namespaceName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainOwnershipValidationResultInner validateCustomDomainOwnership(String resourceGroupName, String namespaceName, Context context) {
        return (CustomDomainOwnershipValidationResultInner)this.beginValidateCustomDomainOwnership(resourceGroupName, namespaceName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamespaceInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NamespaceInner> listBySubscriptionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NamespacesListResult> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NamespaceInner> listBySubscriptionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NamespacesListResult> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamespaceInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NamespaceInner> listByResourceGroupNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NamespacesListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<NamespaceInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<NamespacesListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespacesListResult)res.getValue()).value(), ((NamespacesListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementClientNamespaces")
    public static interface NamespacesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespaceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NamespaceInner> getByResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NamespaceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NamespaceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NamespaceUpdateParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NamespaceUpdateParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/namespaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespacesListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/namespaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NamespacesListResult> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespacesListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NamespacesListResult> listByResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/listKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespaceSharedAccessKeysInner>> listSharedAccessKeys(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/listKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NamespaceSharedAccessKeysInner> listSharedAccessKeysSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/regenerateKey")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> regenerateKey(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NamespaceRegenerateKeyRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/regenerateKey")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> regenerateKeySync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NamespaceRegenerateKeyRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/validateCustomDomainOwnership")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateCustomDomainOwnership(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/validateCustomDomainOwnership")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> validateCustomDomainOwnershipSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespacesListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NamespacesListResult> listBySubscriptionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespacesListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NamespacesListResult> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

