/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceTopicInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.EventInputSchema;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopic;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicProvisioningState;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.PublisherType;
import com.azure.resourcemanager.eventgrid.models.TopicRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.TopicSharedAccessKeys;

public final class NamespaceTopicImpl
implements NamespaceTopic,
NamespaceTopic.Definition,
NamespaceTopic.Update {
    private NamespaceTopicInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String namespaceName;
    private String topicName;
    private NamespaceTopicUpdateParameters updateNamespaceTopicUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public NamespaceTopicProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public PublisherType publisherType() {
        return this.innerModel().publisherType();
    }

    @Override
    public EventInputSchema inputSchema() {
        return this.innerModel().inputSchema();
    }

    @Override
    public Integer eventRetentionInDays() {
        return this.innerModel().eventRetentionInDays();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public NamespaceTopicInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public NamespaceTopicImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        return this;
    }

    @Override
    public NamespaceTopic create() {
        this.innerObject = this.serviceManager.serviceClient().getNamespaceTopics().createOrUpdate(this.resourceGroupName, this.namespaceName, this.topicName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public NamespaceTopic create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamespaceTopics().createOrUpdate(this.resourceGroupName, this.namespaceName, this.topicName, this.innerModel(), context);
        return this;
    }

    NamespaceTopicImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new NamespaceTopicInner();
        this.serviceManager = serviceManager;
        this.topicName = name;
    }

    @Override
    public NamespaceTopicImpl update() {
        this.updateNamespaceTopicUpdateParameters = new NamespaceTopicUpdateParameters();
        return this;
    }

    @Override
    public NamespaceTopic apply() {
        this.innerObject = this.serviceManager.serviceClient().getNamespaceTopics().update(this.resourceGroupName, this.namespaceName, this.topicName, this.updateNamespaceTopicUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public NamespaceTopic apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamespaceTopics().update(this.resourceGroupName, this.namespaceName, this.topicName, this.updateNamespaceTopicUpdateParameters, context);
        return this;
    }

    NamespaceTopicImpl(NamespaceTopicInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.namespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namespaces");
        this.topicName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "topics");
    }

    @Override
    public NamespaceTopic refresh() {
        this.innerObject = (NamespaceTopicInner)((Object)this.serviceManager.serviceClient().getNamespaceTopics().getWithResponse(this.resourceGroupName, this.namespaceName, this.topicName, Context.NONE).getValue());
        return this;
    }

    @Override
    public NamespaceTopic refresh(Context context) {
        this.innerObject = (NamespaceTopicInner)((Object)this.serviceManager.serviceClient().getNamespaceTopics().getWithResponse(this.resourceGroupName, this.namespaceName, this.topicName, context).getValue());
        return this;
    }

    @Override
    public Response<TopicSharedAccessKeys> listSharedAccessKeysWithResponse(Context context) {
        return this.serviceManager.namespaceTopics().listSharedAccessKeysWithResponse(this.resourceGroupName, this.namespaceName, this.topicName, context);
    }

    @Override
    public TopicSharedAccessKeys listSharedAccessKeys() {
        return this.serviceManager.namespaceTopics().listSharedAccessKeys(this.resourceGroupName, this.namespaceName, this.topicName);
    }

    @Override
    public TopicSharedAccessKeys regenerateKey(TopicRegenerateKeyRequest regenerateKeyRequest) {
        return this.serviceManager.namespaceTopics().regenerateKey(this.resourceGroupName, this.namespaceName, this.topicName, regenerateKeyRequest);
    }

    @Override
    public TopicSharedAccessKeys regenerateKey(TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.serviceManager.namespaceTopics().regenerateKey(this.resourceGroupName, this.namespaceName, this.topicName, regenerateKeyRequest, context);
    }

    @Override
    public NamespaceTopicImpl withPublisherType(PublisherType publisherType) {
        this.innerModel().withPublisherType(publisherType);
        return this;
    }

    @Override
    public NamespaceTopicImpl withInputSchema(EventInputSchema inputSchema) {
        this.innerModel().withInputSchema(inputSchema);
        return this;
    }

    @Override
    public NamespaceTopicImpl withEventRetentionInDays(Integer eventRetentionInDays) {
        if (this.isInCreateMode()) {
            this.innerModel().withEventRetentionInDays(eventRetentionInDays);
            return this;
        }
        this.updateNamespaceTopicUpdateParameters.withEventRetentionInDays(eventRetentionInDays);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

