/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeListResult;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventDeliverySchema;
import com.azure.resourcemanager.eventgrid.models.EventSubscription;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFilter;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFullUrl;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionProvisioningState;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.RetryPolicy;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;

public final class EventSubscriptionImpl
implements EventSubscription,
EventSubscription.Definition,
EventSubscription.Update {
    private EventSubscriptionInner innerObject;
    private final EventGridManager serviceManager;
    private String scope;
    private String eventSubscriptionName;
    private EventSubscriptionUpdateParameters updateEventSubscriptionUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String topic() {
        return this.innerModel().topic();
    }

    @Override
    public EventSubscriptionProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public EventSubscriptionDestination destination() {
        return this.innerModel().destination();
    }

    @Override
    public DeliveryWithResourceIdentity deliveryWithResourceIdentity() {
        return this.innerModel().deliveryWithResourceIdentity();
    }

    @Override
    public EventSubscriptionFilter filter() {
        return this.innerModel().filter();
    }

    @Override
    public List<String> labels() {
        List<String> inner = this.innerModel().labels();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public OffsetDateTime expirationTimeUtc() {
        return this.innerModel().expirationTimeUtc();
    }

    @Override
    public EventDeliverySchema eventDeliverySchema() {
        return this.innerModel().eventDeliverySchema();
    }

    @Override
    public RetryPolicy retryPolicy() {
        return this.innerModel().retryPolicy();
    }

    @Override
    public DeadLetterDestination deadLetterDestination() {
        return this.innerModel().deadLetterDestination();
    }

    @Override
    public DeadLetterWithResourceIdentity deadLetterWithResourceIdentity() {
        return this.innerModel().deadLetterWithResourceIdentity();
    }

    @Override
    public EventSubscriptionInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public EventSubscriptionImpl withExistingScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public EventSubscription create() {
        this.innerObject = this.serviceManager.serviceClient().getEventSubscriptions().createOrUpdate(this.scope, this.eventSubscriptionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public EventSubscription create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEventSubscriptions().createOrUpdate(this.scope, this.eventSubscriptionName, this.innerModel(), context);
        return this;
    }

    EventSubscriptionImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new EventSubscriptionInner();
        this.serviceManager = serviceManager;
        this.eventSubscriptionName = name;
    }

    @Override
    public EventSubscriptionImpl update() {
        this.updateEventSubscriptionUpdateParameters = new EventSubscriptionUpdateParameters();
        return this;
    }

    @Override
    public EventSubscription apply() {
        this.innerObject = this.serviceManager.serviceClient().getEventSubscriptions().update(this.scope, this.eventSubscriptionName, this.updateEventSubscriptionUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public EventSubscription apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEventSubscriptions().update(this.scope, this.eventSubscriptionName, this.updateEventSubscriptionUpdateParameters, context);
        return this;
    }

    EventSubscriptionImpl(EventSubscriptionInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.scope = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", "scope");
        this.eventSubscriptionName = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", "eventSubscriptionName");
    }

    @Override
    public EventSubscription refresh() {
        this.innerObject = (EventSubscriptionInner)((Object)this.serviceManager.serviceClient().getEventSubscriptions().getWithResponse(this.scope, this.eventSubscriptionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public EventSubscription refresh(Context context) {
        this.innerObject = (EventSubscriptionInner)((Object)this.serviceManager.serviceClient().getEventSubscriptions().getWithResponse(this.scope, this.eventSubscriptionName, context).getValue());
        return this;
    }

    @Override
    public Response<DeliveryAttributeListResult> getDeliveryAttributesWithResponse(Context context) {
        return this.serviceManager.eventSubscriptions().getDeliveryAttributesWithResponse(this.scope, this.eventSubscriptionName, context);
    }

    @Override
    public DeliveryAttributeListResult getDeliveryAttributes() {
        return this.serviceManager.eventSubscriptions().getDeliveryAttributes(this.scope, this.eventSubscriptionName);
    }

    @Override
    public Response<EventSubscriptionFullUrl> getFullUrlWithResponse(Context context) {
        return this.serviceManager.eventSubscriptions().getFullUrlWithResponse(this.scope, this.eventSubscriptionName, context);
    }

    @Override
    public EventSubscriptionFullUrl getFullUrl() {
        return this.serviceManager.eventSubscriptions().getFullUrl(this.scope, this.eventSubscriptionName);
    }

    @Override
    public EventSubscriptionImpl withDestination(EventSubscriptionDestination destination) {
        if (this.isInCreateMode()) {
            this.innerModel().withDestination(destination);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withDestination(destination);
        return this;
    }

    @Override
    public EventSubscriptionImpl withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity deliveryWithResourceIdentity) {
        if (this.isInCreateMode()) {
            this.innerModel().withDeliveryWithResourceIdentity(deliveryWithResourceIdentity);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withDeliveryWithResourceIdentity(deliveryWithResourceIdentity);
        return this;
    }

    @Override
    public EventSubscriptionImpl withFilter(EventSubscriptionFilter filter) {
        if (this.isInCreateMode()) {
            this.innerModel().withFilter(filter);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withFilter(filter);
        return this;
    }

    @Override
    public EventSubscriptionImpl withLabels(List<String> labels) {
        if (this.isInCreateMode()) {
            this.innerModel().withLabels(labels);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withLabels(labels);
        return this;
    }

    @Override
    public EventSubscriptionImpl withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        if (this.isInCreateMode()) {
            this.innerModel().withExpirationTimeUtc(expirationTimeUtc);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withExpirationTimeUtc(expirationTimeUtc);
        return this;
    }

    @Override
    public EventSubscriptionImpl withEventDeliverySchema(EventDeliverySchema eventDeliverySchema) {
        if (this.isInCreateMode()) {
            this.innerModel().withEventDeliverySchema(eventDeliverySchema);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withEventDeliverySchema(eventDeliverySchema);
        return this;
    }

    @Override
    public EventSubscriptionImpl withRetryPolicy(RetryPolicy retryPolicy) {
        if (this.isInCreateMode()) {
            this.innerModel().withRetryPolicy(retryPolicy);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withRetryPolicy(retryPolicy);
        return this;
    }

    @Override
    public EventSubscriptionImpl withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        if (this.isInCreateMode()) {
            this.innerModel().withDeadLetterDestination(deadLetterDestination);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withDeadLetterDestination(deadLetterDestination);
        return this;
    }

    @Override
    public EventSubscriptionImpl withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterWithResourceIdentity) {
        if (this.isInCreateMode()) {
            this.innerModel().withDeadLetterWithResourceIdentity(deadLetterWithResourceIdentity);
            return this;
        }
        this.updateEventSubscriptionUpdateParameters.withDeadLetterWithResourceIdentity(deadLetterWithResourceIdentity);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

