/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.eventgrid.fluent.CaCertificatesClient;
import com.azure.resourcemanager.eventgrid.fluent.ChannelsClient;
import com.azure.resourcemanager.eventgrid.fluent.ClientGroupsClient;
import com.azure.resourcemanager.eventgrid.fluent.ClientsClient;
import com.azure.resourcemanager.eventgrid.fluent.DomainEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.DomainTopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.DomainTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.DomainsClient;
import com.azure.resourcemanager.eventgrid.fluent.EventGridManagementClient;
import com.azure.resourcemanager.eventgrid.fluent.EventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.ExtensionTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.NamespaceTopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.NamespaceTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.NamespacesClient;
import com.azure.resourcemanager.eventgrid.fluent.NetworkSecurityPerimeterConfigurationsClient;
import com.azure.resourcemanager.eventgrid.fluent.OperationsClient;
import com.azure.resourcemanager.eventgrid.fluent.PartnerConfigurationsClient;
import com.azure.resourcemanager.eventgrid.fluent.PartnerDestinationsClient;
import com.azure.resourcemanager.eventgrid.fluent.PartnerNamespacesClient;
import com.azure.resourcemanager.eventgrid.fluent.PartnerRegistrationsClient;
import com.azure.resourcemanager.eventgrid.fluent.PartnerTopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.PartnerTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.PermissionBindingsClient;
import com.azure.resourcemanager.eventgrid.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.eventgrid.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.eventgrid.fluent.SystemTopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.SystemTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.TopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.TopicSpacesClient;
import com.azure.resourcemanager.eventgrid.fluent.TopicTypesClient;
import com.azure.resourcemanager.eventgrid.fluent.TopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.VerifiedPartnersClient;
import com.azure.resourcemanager.eventgrid.implementation.CaCertificatesClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.ChannelsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.ClientGroupsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.ClientsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainEventSubscriptionsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainTopicEventSubscriptionsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainTopicsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientBuilder;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.ExtensionTopicsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespaceTopicEventSubscriptionsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespaceTopicsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespacesClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.NetworkSecurityPerimeterConfigurationsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.OperationsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerConfigurationsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerDestinationsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerNamespacesClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerRegistrationsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerTopicEventSubscriptionsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerTopicsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PermissionBindingsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicEventSubscriptionsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicEventSubscriptionsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicSpacesClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicTypesClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicsClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.VerifiedPartnersClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EventGridManagementClientBuilder.class)
public final class EventGridManagementClientImpl
implements EventGridManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final CaCertificatesClient caCertificates;
    private final ChannelsClient channels;
    private final ClientGroupsClient clientGroups;
    private final ClientsClient clients;
    private final DomainsClient domains;
    private final DomainTopicsClient domainTopics;
    private final DomainTopicEventSubscriptionsClient domainTopicEventSubscriptions;
    private final TopicEventSubscriptionsClient topicEventSubscriptions;
    private final DomainEventSubscriptionsClient domainEventSubscriptions;
    private final EventSubscriptionsClient eventSubscriptions;
    private final SystemTopicEventSubscriptionsClient systemTopicEventSubscriptions;
    private final NamespaceTopicEventSubscriptionsClient namespaceTopicEventSubscriptions;
    private final PartnerTopicEventSubscriptionsClient partnerTopicEventSubscriptions;
    private final NamespacesClient namespaces;
    private final NamespaceTopicsClient namespaceTopics;
    private final OperationsClient operations;
    private final PartnerConfigurationsClient partnerConfigurations;
    private final PartnerDestinationsClient partnerDestinations;
    private final PartnerNamespacesClient partnerNamespaces;
    private final PartnerRegistrationsClient partnerRegistrations;
    private final PartnerTopicsClient partnerTopics;
    private final NetworkSecurityPerimeterConfigurationsClient networkSecurityPerimeterConfigurations;
    private final PermissionBindingsClient permissionBindings;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final SystemTopicsClient systemTopics;
    private final TopicsClient topics;
    private final ExtensionTopicsClient extensionTopics;
    private final TopicSpacesClient topicSpaces;
    private final TopicTypesClient topicTypes;
    private final VerifiedPartnersClient verifiedPartners;
    private static final ClientLogger LOGGER = new ClientLogger(EventGridManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public CaCertificatesClient getCaCertificates() {
        return this.caCertificates;
    }

    @Override
    public ChannelsClient getChannels() {
        return this.channels;
    }

    @Override
    public ClientGroupsClient getClientGroups() {
        return this.clientGroups;
    }

    @Override
    public ClientsClient getClients() {
        return this.clients;
    }

    @Override
    public DomainsClient getDomains() {
        return this.domains;
    }

    @Override
    public DomainTopicsClient getDomainTopics() {
        return this.domainTopics;
    }

    @Override
    public DomainTopicEventSubscriptionsClient getDomainTopicEventSubscriptions() {
        return this.domainTopicEventSubscriptions;
    }

    @Override
    public TopicEventSubscriptionsClient getTopicEventSubscriptions() {
        return this.topicEventSubscriptions;
    }

    @Override
    public DomainEventSubscriptionsClient getDomainEventSubscriptions() {
        return this.domainEventSubscriptions;
    }

    @Override
    public EventSubscriptionsClient getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    @Override
    public SystemTopicEventSubscriptionsClient getSystemTopicEventSubscriptions() {
        return this.systemTopicEventSubscriptions;
    }

    @Override
    public NamespaceTopicEventSubscriptionsClient getNamespaceTopicEventSubscriptions() {
        return this.namespaceTopicEventSubscriptions;
    }

    @Override
    public PartnerTopicEventSubscriptionsClient getPartnerTopicEventSubscriptions() {
        return this.partnerTopicEventSubscriptions;
    }

    @Override
    public NamespacesClient getNamespaces() {
        return this.namespaces;
    }

    @Override
    public NamespaceTopicsClient getNamespaceTopics() {
        return this.namespaceTopics;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public PartnerConfigurationsClient getPartnerConfigurations() {
        return this.partnerConfigurations;
    }

    @Override
    public PartnerDestinationsClient getPartnerDestinations() {
        return this.partnerDestinations;
    }

    @Override
    public PartnerNamespacesClient getPartnerNamespaces() {
        return this.partnerNamespaces;
    }

    @Override
    public PartnerRegistrationsClient getPartnerRegistrations() {
        return this.partnerRegistrations;
    }

    @Override
    public PartnerTopicsClient getPartnerTopics() {
        return this.partnerTopics;
    }

    @Override
    public NetworkSecurityPerimeterConfigurationsClient getNetworkSecurityPerimeterConfigurations() {
        return this.networkSecurityPerimeterConfigurations;
    }

    @Override
    public PermissionBindingsClient getPermissionBindings() {
        return this.permissionBindings;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public SystemTopicsClient getSystemTopics() {
        return this.systemTopics;
    }

    @Override
    public TopicsClient getTopics() {
        return this.topics;
    }

    @Override
    public ExtensionTopicsClient getExtensionTopics() {
        return this.extensionTopics;
    }

    @Override
    public TopicSpacesClient getTopicSpaces() {
        return this.topicSpaces;
    }

    @Override
    public TopicTypesClient getTopicTypes() {
        return this.topicTypes;
    }

    @Override
    public VerifiedPartnersClient getVerifiedPartners() {
        return this.verifiedPartners;
    }

    EventGridManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-04-01-preview";
        this.caCertificates = new CaCertificatesClientImpl(this);
        this.channels = new ChannelsClientImpl(this);
        this.clientGroups = new ClientGroupsClientImpl(this);
        this.clients = new ClientsClientImpl(this);
        this.domains = new DomainsClientImpl(this);
        this.domainTopics = new DomainTopicsClientImpl(this);
        this.domainTopicEventSubscriptions = new DomainTopicEventSubscriptionsClientImpl(this);
        this.topicEventSubscriptions = new TopicEventSubscriptionsClientImpl(this);
        this.domainEventSubscriptions = new DomainEventSubscriptionsClientImpl(this);
        this.eventSubscriptions = new EventSubscriptionsClientImpl(this);
        this.systemTopicEventSubscriptions = new SystemTopicEventSubscriptionsClientImpl(this);
        this.namespaceTopicEventSubscriptions = new NamespaceTopicEventSubscriptionsClientImpl(this);
        this.partnerTopicEventSubscriptions = new PartnerTopicEventSubscriptionsClientImpl(this);
        this.namespaces = new NamespacesClientImpl(this);
        this.namespaceTopics = new NamespaceTopicsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.partnerConfigurations = new PartnerConfigurationsClientImpl(this);
        this.partnerDestinations = new PartnerDestinationsClientImpl(this);
        this.partnerNamespaces = new PartnerNamespacesClientImpl(this);
        this.partnerRegistrations = new PartnerRegistrationsClientImpl(this);
        this.partnerTopics = new PartnerTopicsClientImpl(this);
        this.networkSecurityPerimeterConfigurations = new NetworkSecurityPerimeterConfigurationsClientImpl(this);
        this.permissionBindings = new PermissionBindingsClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.systemTopics = new SystemTopicsClientImpl(this);
        this.topics = new TopicsClientImpl(this);
        this.extensionTopics = new ExtensionTopicsClientImpl(this);
        this.topicSpaces = new TopicSpacesClientImpl(this);
        this.topicTypes = new TopicTypesClientImpl(this);
        this.verifiedPartners = new VerifiedPartnersClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

