/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.DomainInner;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.DataResidencyBoundary;
import com.azure.resourcemanager.eventgrid.models.Domain;
import com.azure.resourcemanager.eventgrid.models.DomainProvisioningState;
import com.azure.resourcemanager.eventgrid.models.DomainRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.DomainSharedAccessKeys;
import com.azure.resourcemanager.eventgrid.models.DomainUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.InputSchema;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnection;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.ResourceSku;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class DomainImpl
implements Domain,
Domain.Definition,
Domain.Update {
    private DomainInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String domainName;
    private DomainUpdateParameters updateDomainUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ResourceSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public IdentityInfo identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public DomainProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public TlsVersion minimumTlsVersionAllowed() {
        return this.innerModel().minimumTlsVersionAllowed();
    }

    @Override
    public String endpoint() {
        return this.innerModel().endpoint();
    }

    @Override
    public InputSchema inputSchema() {
        return this.innerModel().inputSchema();
    }

    @Override
    public EventTypeInfo eventTypeInfo() {
        return this.innerModel().eventTypeInfo();
    }

    @Override
    public InputSchemaMapping inputSchemaMapping() {
        return this.innerModel().inputSchemaMapping();
    }

    @Override
    public String metricResourceId() {
        return this.innerModel().metricResourceId();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public List<InboundIpRule> inboundIpRules() {
        List<InboundIpRule> inner = this.innerModel().inboundIpRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean disableLocalAuth() {
        return this.innerModel().disableLocalAuth();
    }

    @Override
    public Boolean autoCreateTopicWithFirstSubscription() {
        return this.innerModel().autoCreateTopicWithFirstSubscription();
    }

    @Override
    public Boolean autoDeleteTopicWithLastSubscription() {
        return this.innerModel().autoDeleteTopicWithLastSubscription();
    }

    @Override
    public DataResidencyBoundary dataResidencyBoundary() {
        return this.innerModel().dataResidencyBoundary();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DomainInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public DomainImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Domain create() {
        this.innerObject = this.serviceManager.serviceClient().getDomains().createOrUpdate(this.resourceGroupName, this.domainName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Domain create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDomains().createOrUpdate(this.resourceGroupName, this.domainName, this.innerModel(), context);
        return this;
    }

    DomainImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new DomainInner();
        this.serviceManager = serviceManager;
        this.domainName = name;
    }

    @Override
    public DomainImpl update() {
        this.updateDomainUpdateParameters = new DomainUpdateParameters();
        return this;
    }

    @Override
    public Domain apply() {
        this.innerObject = this.serviceManager.serviceClient().getDomains().update(this.resourceGroupName, this.domainName, this.updateDomainUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public Domain apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDomains().update(this.resourceGroupName, this.domainName, this.updateDomainUpdateParameters, context);
        return this;
    }

    DomainImpl(DomainInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.domainName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "domains");
    }

    @Override
    public Domain refresh() {
        this.innerObject = (DomainInner)((Object)this.serviceManager.serviceClient().getDomains().getByResourceGroupWithResponse(this.resourceGroupName, this.domainName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Domain refresh(Context context) {
        this.innerObject = (DomainInner)((Object)this.serviceManager.serviceClient().getDomains().getByResourceGroupWithResponse(this.resourceGroupName, this.domainName, context).getValue());
        return this;
    }

    @Override
    public Response<DomainSharedAccessKeys> listSharedAccessKeysWithResponse(Context context) {
        return this.serviceManager.domains().listSharedAccessKeysWithResponse(this.resourceGroupName, this.domainName, context);
    }

    @Override
    public DomainSharedAccessKeys listSharedAccessKeys() {
        return this.serviceManager.domains().listSharedAccessKeys(this.resourceGroupName, this.domainName);
    }

    @Override
    public Response<DomainSharedAccessKeys> regenerateKeyWithResponse(DomainRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.serviceManager.domains().regenerateKeyWithResponse(this.resourceGroupName, this.domainName, regenerateKeyRequest, context);
    }

    @Override
    public DomainSharedAccessKeys regenerateKey(DomainRegenerateKeyRequest regenerateKeyRequest) {
        return this.serviceManager.domains().regenerateKey(this.resourceGroupName, this.domainName, regenerateKeyRequest);
    }

    @Override
    public DomainImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DomainImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DomainImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateDomainUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public DomainImpl withSku(ResourceSku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateDomainUpdateParameters.withSku(sku);
        return this;
    }

    @Override
    public DomainImpl withIdentity(IdentityInfo identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateDomainUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public DomainImpl withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        if (this.isInCreateMode()) {
            this.innerModel().withMinimumTlsVersionAllowed(minimumTlsVersionAllowed);
            return this;
        }
        this.updateDomainUpdateParameters.withMinimumTlsVersionAllowed(minimumTlsVersionAllowed);
        return this;
    }

    @Override
    public DomainImpl withInputSchema(InputSchema inputSchema) {
        this.innerModel().withInputSchema(inputSchema);
        return this;
    }

    @Override
    public DomainImpl withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        if (this.isInCreateMode()) {
            this.innerModel().withEventTypeInfo(eventTypeInfo);
            return this;
        }
        this.updateDomainUpdateParameters.withEventTypeInfo(eventTypeInfo);
        return this;
    }

    @Override
    public DomainImpl withInputSchemaMapping(InputSchemaMapping inputSchemaMapping) {
        this.innerModel().withInputSchemaMapping(inputSchemaMapping);
        return this;
    }

    @Override
    public DomainImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateDomainUpdateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public DomainImpl withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.isInCreateMode()) {
            this.innerModel().withInboundIpRules(inboundIpRules);
            return this;
        }
        this.updateDomainUpdateParameters.withInboundIpRules(inboundIpRules);
        return this;
    }

    @Override
    public DomainImpl withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisableLocalAuth(disableLocalAuth);
            return this;
        }
        this.updateDomainUpdateParameters.withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    @Override
    public DomainImpl withAutoCreateTopicWithFirstSubscription(Boolean autoCreateTopicWithFirstSubscription) {
        if (this.isInCreateMode()) {
            this.innerModel().withAutoCreateTopicWithFirstSubscription(autoCreateTopicWithFirstSubscription);
            return this;
        }
        this.updateDomainUpdateParameters.withAutoCreateTopicWithFirstSubscription(autoCreateTopicWithFirstSubscription);
        return this;
    }

    @Override
    public DomainImpl withAutoDeleteTopicWithLastSubscription(Boolean autoDeleteTopicWithLastSubscription) {
        if (this.isInCreateMode()) {
            this.innerModel().withAutoDeleteTopicWithLastSubscription(autoDeleteTopicWithLastSubscription);
            return this;
        }
        this.updateDomainUpdateParameters.withAutoDeleteTopicWithLastSubscription(autoDeleteTopicWithLastSubscription);
        return this;
    }

    @Override
    public DomainImpl withDataResidencyBoundary(DataResidencyBoundary dataResidencyBoundary) {
        if (this.isInCreateMode()) {
            this.innerModel().withDataResidencyBoundary(dataResidencyBoundary);
            return this;
        }
        this.updateDomainUpdateParameters.withDataResidencyBoundary(dataResidencyBoundary);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

