/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.CaCertificateInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.CaCertificate;
import com.azure.resourcemanager.eventgrid.models.CaCertificateProvisioningState;
import java.time.OffsetDateTime;

public final class CaCertificateImpl
implements CaCertificate,
CaCertificate.Definition,
CaCertificate.Update {
    private CaCertificateInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String namespaceName;
    private String caCertificateName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String encodedCertificate() {
        return this.innerModel().encodedCertificate();
    }

    @Override
    public OffsetDateTime issueTimeInUtc() {
        return this.innerModel().issueTimeInUtc();
    }

    @Override
    public OffsetDateTime expiryTimeInUtc() {
        return this.innerModel().expiryTimeInUtc();
    }

    @Override
    public CaCertificateProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CaCertificateInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public CaCertificateImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        return this;
    }

    @Override
    public CaCertificate create() {
        this.innerObject = this.serviceManager.serviceClient().getCaCertificates().createOrUpdate(this.resourceGroupName, this.namespaceName, this.caCertificateName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public CaCertificate create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaCertificates().createOrUpdate(this.resourceGroupName, this.namespaceName, this.caCertificateName, this.innerModel(), context);
        return this;
    }

    CaCertificateImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new CaCertificateInner();
        this.serviceManager = serviceManager;
        this.caCertificateName = name;
    }

    @Override
    public CaCertificateImpl update() {
        return this;
    }

    @Override
    public CaCertificate apply() {
        this.innerObject = this.serviceManager.serviceClient().getCaCertificates().createOrUpdate(this.resourceGroupName, this.namespaceName, this.caCertificateName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public CaCertificate apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaCertificates().createOrUpdate(this.resourceGroupName, this.namespaceName, this.caCertificateName, this.innerModel(), context);
        return this;
    }

    CaCertificateImpl(CaCertificateInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.namespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namespaces");
        this.caCertificateName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "caCertificates");
    }

    @Override
    public CaCertificate refresh() {
        this.innerObject = (CaCertificateInner)((Object)this.serviceManager.serviceClient().getCaCertificates().getWithResponse(this.resourceGroupName, this.namespaceName, this.caCertificateName, Context.NONE).getValue());
        return this;
    }

    @Override
    public CaCertificate refresh(Context context) {
        this.innerObject = (CaCertificateInner)((Object)this.serviceManager.serviceClient().getCaCertificates().getWithResponse(this.resourceGroupName, this.namespaceName, this.caCertificateName, context).getValue());
        return this;
    }

    @Override
    public CaCertificateImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public CaCertificateImpl withEncodedCertificate(String encodedCertificate) {
        this.innerModel().withEncodedCertificate(encodedCertificate);
        return this;
    }
}

