/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ResourceRegionType;
import com.azure.resourcemanager.eventgrid.models.TopicTypeAdditionalEnforcedPermission;
import com.azure.resourcemanager.eventgrid.models.TopicTypeProvisioningState;
import com.azure.resourcemanager.eventgrid.models.TopicTypeSourceScope;
import java.io.IOException;
import java.util.List;

public final class TopicTypeProperties
implements JsonSerializable<TopicTypeProperties> {
    private String provider;
    private String displayName;
    private String description;
    private ResourceRegionType resourceRegionType;
    private TopicTypeProvisioningState provisioningState;
    private List<String> supportedLocations;
    private String sourceResourceFormat;
    private List<TopicTypeSourceScope> supportedScopesForSource;
    private Boolean areRegionalAndGlobalSourcesSupported;
    private List<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions;

    public String provider() {
        return this.provider;
    }

    public TopicTypeProperties withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public TopicTypeProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public TopicTypeProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public ResourceRegionType resourceRegionType() {
        return this.resourceRegionType;
    }

    public TopicTypeProperties withResourceRegionType(ResourceRegionType resourceRegionType) {
        this.resourceRegionType = resourceRegionType;
        return this;
    }

    public TopicTypeProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public TopicTypeProperties withProvisioningState(TopicTypeProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public List<String> supportedLocations() {
        return this.supportedLocations;
    }

    public TopicTypeProperties withSupportedLocations(List<String> supportedLocations) {
        this.supportedLocations = supportedLocations;
        return this;
    }

    public String sourceResourceFormat() {
        return this.sourceResourceFormat;
    }

    public TopicTypeProperties withSourceResourceFormat(String sourceResourceFormat) {
        this.sourceResourceFormat = sourceResourceFormat;
        return this;
    }

    public List<TopicTypeSourceScope> supportedScopesForSource() {
        return this.supportedScopesForSource;
    }

    public TopicTypeProperties withSupportedScopesForSource(List<TopicTypeSourceScope> supportedScopesForSource) {
        this.supportedScopesForSource = supportedScopesForSource;
        return this;
    }

    public Boolean areRegionalAndGlobalSourcesSupported() {
        return this.areRegionalAndGlobalSourcesSupported;
    }

    public TopicTypeProperties withAreRegionalAndGlobalSourcesSupported(Boolean areRegionalAndGlobalSourcesSupported) {
        this.areRegionalAndGlobalSourcesSupported = areRegionalAndGlobalSourcesSupported;
        return this;
    }

    public List<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions() {
        return this.additionalEnforcedPermissions;
    }

    public TopicTypeProperties withAdditionalEnforcedPermissions(List<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions) {
        this.additionalEnforcedPermissions = additionalEnforcedPermissions;
        return this;
    }

    public void validate() {
        if (this.additionalEnforcedPermissions() != null) {
            this.additionalEnforcedPermissions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("resourceRegionType", this.resourceRegionType == null ? null : this.resourceRegionType.toString());
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeArrayField("supportedLocations", this.supportedLocations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("sourceResourceFormat", this.sourceResourceFormat);
        jsonWriter.writeArrayField("supportedScopesForSource", this.supportedScopesForSource, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeBooleanField("areRegionalAndGlobalSourcesSupported", this.areRegionalAndGlobalSourcesSupported);
        jsonWriter.writeArrayField("additionalEnforcedPermissions", this.additionalEnforcedPermissions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TopicTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TopicTypeProperties)jsonReader.readObject(reader -> {
            TopicTypeProperties deserializedTopicTypeProperties = new TopicTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provider".equals(fieldName)) {
                    deserializedTopicTypeProperties.provider = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedTopicTypeProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedTopicTypeProperties.description = reader.getString();
                    continue;
                }
                if ("resourceRegionType".equals(fieldName)) {
                    deserializedTopicTypeProperties.resourceRegionType = ResourceRegionType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTopicTypeProperties.provisioningState = TopicTypeProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("supportedLocations".equals(fieldName)) {
                    List supportedLocations;
                    deserializedTopicTypeProperties.supportedLocations = supportedLocations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sourceResourceFormat".equals(fieldName)) {
                    deserializedTopicTypeProperties.sourceResourceFormat = reader.getString();
                    continue;
                }
                if ("supportedScopesForSource".equals(fieldName)) {
                    List supportedScopesForSource;
                    deserializedTopicTypeProperties.supportedScopesForSource = supportedScopesForSource = reader.readArray(reader1 -> TopicTypeSourceScope.fromString(reader1.getString()));
                    continue;
                }
                if ("areRegionalAndGlobalSourcesSupported".equals(fieldName)) {
                    deserializedTopicTypeProperties.areRegionalAndGlobalSourcesSupported = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("additionalEnforcedPermissions".equals(fieldName)) {
                    List additionalEnforcedPermissions;
                    deserializedTopicTypeProperties.additionalEnforcedPermissions = additionalEnforcedPermissions = reader.readArray(reader1 -> TopicTypeAdditionalEnforcedPermission.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopicTypeProperties;
        });
    }
}

