/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.models.DataResidencyBoundary;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.InputSchema;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import com.azure.resourcemanager.eventgrid.models.TopicProvisioningState;
import java.io.IOException;
import java.util.List;

public final class TopicProperties
implements JsonSerializable<TopicProperties> {
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private TopicProvisioningState provisioningState;
    private String endpoint;
    private EventTypeInfo eventTypeInfo;
    private TlsVersion minimumTlsVersionAllowed;
    private InputSchema inputSchema;
    private InputSchemaMapping inputSchemaMapping;
    private String metricResourceId;
    private PublicNetworkAccess publicNetworkAccess;
    private List<InboundIpRule> inboundIpRules;
    private Boolean disableLocalAuth;
    private DataResidencyBoundary dataResidencyBoundary;

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public TopicProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public EventTypeInfo eventTypeInfo() {
        return this.eventTypeInfo;
    }

    public TopicProperties withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.eventTypeInfo = eventTypeInfo;
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    public TopicProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    public InputSchema inputSchema() {
        return this.inputSchema;
    }

    public TopicProperties withInputSchema(InputSchema inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    public InputSchemaMapping inputSchemaMapping() {
        return this.inputSchemaMapping;
    }

    public TopicProperties withInputSchemaMapping(InputSchemaMapping inputSchemaMapping) {
        this.inputSchemaMapping = inputSchemaMapping;
        return this;
    }

    public String metricResourceId() {
        return this.metricResourceId;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public TopicProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    public TopicProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public TopicProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public DataResidencyBoundary dataResidencyBoundary() {
        return this.dataResidencyBoundary;
    }

    public TopicProperties withDataResidencyBoundary(DataResidencyBoundary dataResidencyBoundary) {
        this.dataResidencyBoundary = dataResidencyBoundary;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.eventTypeInfo() != null) {
            this.eventTypeInfo().validate();
        }
        if (this.inputSchemaMapping() != null) {
            this.inputSchemaMapping().validate();
        }
        if (this.inboundIpRules() != null) {
            this.inboundIpRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("eventTypeInfo", (JsonSerializable)this.eventTypeInfo);
        jsonWriter.writeStringField("minimumTlsVersionAllowed", this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        jsonWriter.writeStringField("inputSchema", this.inputSchema == null ? null : this.inputSchema.toString());
        jsonWriter.writeJsonField("inputSchemaMapping", (JsonSerializable)this.inputSchemaMapping);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeStringField("dataResidencyBoundary", this.dataResidencyBoundary == null ? null : this.dataResidencyBoundary.toString());
        return jsonWriter.writeEndObject();
    }

    public static TopicProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TopicProperties)jsonReader.readObject(reader -> {
            TopicProperties deserializedTopicProperties = new TopicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedTopicProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTopicProperties.provisioningState = TopicProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedTopicProperties.endpoint = reader.getString();
                    continue;
                }
                if ("eventTypeInfo".equals(fieldName)) {
                    deserializedTopicProperties.eventTypeInfo = EventTypeInfo.fromJson(reader);
                    continue;
                }
                if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedTopicProperties.minimumTlsVersionAllowed = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("inputSchema".equals(fieldName)) {
                    deserializedTopicProperties.inputSchema = InputSchema.fromString(reader.getString());
                    continue;
                }
                if ("inputSchemaMapping".equals(fieldName)) {
                    deserializedTopicProperties.inputSchemaMapping = InputSchemaMapping.fromJson(reader);
                    continue;
                }
                if ("metricResourceId".equals(fieldName)) {
                    deserializedTopicProperties.metricResourceId = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedTopicProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("inboundIpRules".equals(fieldName)) {
                    List inboundIpRules;
                    deserializedTopicProperties.inboundIpRules = inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedTopicProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dataResidencyBoundary".equals(fieldName)) {
                    deserializedTopicProperties.dataResidencyBoundary = DataResidencyBoundary.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopicProperties;
        });
    }
}

