/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaceProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicRoutingMode;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.io.IOException;
import java.util.List;

public final class PartnerNamespaceProperties
implements JsonSerializable<PartnerNamespaceProperties> {
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private PartnerNamespaceProvisioningState provisioningState;
    private String partnerRegistrationFullyQualifiedId;
    private TlsVersion minimumTlsVersionAllowed;
    private String endpoint;
    private PublicNetworkAccess publicNetworkAccess;
    private List<InboundIpRule> inboundIpRules;
    private Boolean disableLocalAuth;
    private PartnerTopicRoutingMode partnerTopicRoutingMode;

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PartnerNamespaceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String partnerRegistrationFullyQualifiedId() {
        return this.partnerRegistrationFullyQualifiedId;
    }

    public PartnerNamespaceProperties withPartnerRegistrationFullyQualifiedId(String partnerRegistrationFullyQualifiedId) {
        this.partnerRegistrationFullyQualifiedId = partnerRegistrationFullyQualifiedId;
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    public PartnerNamespaceProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public PartnerNamespaceProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    public PartnerNamespaceProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public PartnerNamespaceProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public PartnerTopicRoutingMode partnerTopicRoutingMode() {
        return this.partnerTopicRoutingMode;
    }

    public PartnerNamespaceProperties withPartnerTopicRoutingMode(PartnerTopicRoutingMode partnerTopicRoutingMode) {
        this.partnerTopicRoutingMode = partnerTopicRoutingMode;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.inboundIpRules() != null) {
            this.inboundIpRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationFullyQualifiedId", this.partnerRegistrationFullyQualifiedId);
        jsonWriter.writeStringField("minimumTlsVersionAllowed", this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeStringField("partnerTopicRoutingMode", this.partnerTopicRoutingMode == null ? null : this.partnerTopicRoutingMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static PartnerNamespaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerNamespaceProperties)jsonReader.readObject(reader -> {
            PartnerNamespaceProperties deserializedPartnerNamespaceProperties = new PartnerNamespaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedPartnerNamespaceProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPartnerNamespaceProperties.provisioningState = PartnerNamespaceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("partnerRegistrationFullyQualifiedId".equals(fieldName)) {
                    deserializedPartnerNamespaceProperties.partnerRegistrationFullyQualifiedId = reader.getString();
                    continue;
                }
                if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedPartnerNamespaceProperties.minimumTlsVersionAllowed = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedPartnerNamespaceProperties.endpoint = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedPartnerNamespaceProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("inboundIpRules".equals(fieldName)) {
                    List inboundIpRules;
                    deserializedPartnerNamespaceProperties.inboundIpRules = inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedPartnerNamespaceProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("partnerTopicRoutingMode".equals(fieldName)) {
                    deserializedPartnerNamespaceProperties.partnerTopicRoutingMode = PartnerTopicRoutingMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerNamespaceProperties;
        });
    }
}

