/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class PartnerDestinationInner
extends Resource {
    private PartnerDestinationProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private PartnerDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public PartnerDestinationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PartnerDestinationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public UUID partnerRegistrationImmutableId() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerRegistrationImmutableId();
    }

    public PartnerDestinationInner withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerDestinationProperties();
        }
        this.innerProperties().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    public String endpointServiceContext() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointServiceContext();
    }

    public PartnerDestinationInner withEndpointServiceContext(String endpointServiceContext) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerDestinationProperties();
        }
        this.innerProperties().withEndpointServiceContext(endpointServiceContext);
        return this;
    }

    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimeIfNotActivatedUtc();
    }

    public PartnerDestinationInner withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerDestinationProperties();
        }
        this.innerProperties().withExpirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc);
        return this;
    }

    public PartnerDestinationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PartnerDestinationActivationState activationState() {
        return this.innerProperties() == null ? null : this.innerProperties().activationState();
    }

    public PartnerDestinationInner withActivationState(PartnerDestinationActivationState activationState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerDestinationProperties();
        }
        this.innerProperties().withActivationState(activationState);
        return this;
    }

    public String endpointBaseUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointBaseUrl();
    }

    public PartnerDestinationInner withEndpointBaseUrl(String endpointBaseUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerDestinationProperties();
        }
        this.innerProperties().withEndpointBaseUrl(endpointBaseUrl);
        return this;
    }

    public String messageForActivation() {
        return this.innerProperties() == null ? null : this.innerProperties().messageForActivation();
    }

    public PartnerDestinationInner withMessageForActivation(String messageForActivation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerDestinationProperties();
        }
        this.innerProperties().withMessageForActivation(messageForActivation);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PartnerDestinationInner fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerDestinationInner)((Object)jsonReader.readObject(reader -> {
            PartnerDestinationInner deserializedPartnerDestinationInner = new PartnerDestinationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPartnerDestinationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPartnerDestinationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPartnerDestinationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPartnerDestinationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPartnerDestinationInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPartnerDestinationInner.innerProperties = PartnerDestinationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPartnerDestinationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerDestinationInner;
        }));
    }
}

