/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerAuthorization;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurationProvisioningState;
import java.io.IOException;

public final class PartnerConfigurationProperties
implements JsonSerializable<PartnerConfigurationProperties> {
    private PartnerAuthorization partnerAuthorization;
    private PartnerConfigurationProvisioningState provisioningState;

    public PartnerAuthorization partnerAuthorization() {
        return this.partnerAuthorization;
    }

    public PartnerConfigurationProperties withPartnerAuthorization(PartnerAuthorization partnerAuthorization) {
        this.partnerAuthorization = partnerAuthorization;
        return this;
    }

    public PartnerConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PartnerConfigurationProperties withProvisioningState(PartnerConfigurationProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.partnerAuthorization() != null) {
            this.partnerAuthorization().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("partnerAuthorization", (JsonSerializable)this.partnerAuthorization);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    public static PartnerConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerConfigurationProperties)jsonReader.readObject(reader -> {
            PartnerConfigurationProperties deserializedPartnerConfigurationProperties = new PartnerConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partnerAuthorization".equals(fieldName)) {
                    deserializedPartnerConfigurationProperties.partnerAuthorization = PartnerAuthorization.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPartnerConfigurationProperties.provisioningState = PartnerConfigurationProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerConfigurationProperties;
        });
    }
}

