/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterInfo;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterProfileAccessRuleDirection;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterSubscription;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterProfileAccessRuleProperties
implements JsonSerializable<NetworkSecurityPerimeterProfileAccessRuleProperties> {
    private NetworkSecurityPerimeterProfileAccessRuleDirection direction;
    private List<String> addressPrefixes;
    private List<NetworkSecurityPerimeterSubscription> subscriptions;
    private List<NetworkSecurityPerimeterInfo> networkSecurityPerimeters;
    private List<String> fullyQualifiedDomainNames;
    private List<String> emailAddresses;
    private List<String> phoneNumbers;

    public NetworkSecurityPerimeterProfileAccessRuleDirection direction() {
        return this.direction;
    }

    public NetworkSecurityPerimeterProfileAccessRuleProperties withDirection(NetworkSecurityPerimeterProfileAccessRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public NetworkSecurityPerimeterProfileAccessRuleProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public List<NetworkSecurityPerimeterSubscription> subscriptions() {
        return this.subscriptions;
    }

    public NetworkSecurityPerimeterProfileAccessRuleProperties withSubscriptions(List<NetworkSecurityPerimeterSubscription> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public List<NetworkSecurityPerimeterInfo> networkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    public NetworkSecurityPerimeterProfileAccessRuleProperties withNetworkSecurityPerimeters(List<NetworkSecurityPerimeterInfo> networkSecurityPerimeters) {
        this.networkSecurityPerimeters = networkSecurityPerimeters;
        return this;
    }

    public List<String> fullyQualifiedDomainNames() {
        return this.fullyQualifiedDomainNames;
    }

    public NetworkSecurityPerimeterProfileAccessRuleProperties withFullyQualifiedDomainNames(List<String> fullyQualifiedDomainNames) {
        this.fullyQualifiedDomainNames = fullyQualifiedDomainNames;
        return this;
    }

    public List<String> emailAddresses() {
        return this.emailAddresses;
    }

    public NetworkSecurityPerimeterProfileAccessRuleProperties withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public List<String> phoneNumbers() {
        return this.phoneNumbers;
    }

    public NetworkSecurityPerimeterProfileAccessRuleProperties withPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public void validate() {
        if (this.subscriptions() != null) {
            this.subscriptions().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeters() != null) {
            this.networkSecurityPerimeters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("subscriptions", this.subscriptions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("networkSecurityPerimeters", this.networkSecurityPerimeters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("fullyQualifiedDomainNames", this.fullyQualifiedDomainNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("emailAddresses", this.emailAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("phoneNumbers", this.phoneNumbers, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterProfileAccessRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterProfileAccessRuleProperties)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterProfileAccessRuleProperties deserializedNetworkSecurityPerimeterProfileAccessRuleProperties = new NetworkSecurityPerimeterProfileAccessRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("direction".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterProfileAccessRuleProperties.direction = NetworkSecurityPerimeterProfileAccessRuleDirection.fromString(reader.getString());
                    continue;
                }
                if ("addressPrefixes".equals(fieldName)) {
                    List addressPrefixes;
                    deserializedNetworkSecurityPerimeterProfileAccessRuleProperties.addressPrefixes = addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("subscriptions".equals(fieldName)) {
                    List subscriptions;
                    deserializedNetworkSecurityPerimeterProfileAccessRuleProperties.subscriptions = subscriptions = reader.readArray(reader1 -> NetworkSecurityPerimeterSubscription.fromJson(reader1));
                    continue;
                }
                if ("networkSecurityPerimeters".equals(fieldName)) {
                    List networkSecurityPerimeters;
                    deserializedNetworkSecurityPerimeterProfileAccessRuleProperties.networkSecurityPerimeters = networkSecurityPerimeters = reader.readArray(reader1 -> NetworkSecurityPerimeterInfo.fromJson(reader1));
                    continue;
                }
                if ("fullyQualifiedDomainNames".equals(fieldName)) {
                    List fullyQualifiedDomainNames;
                    deserializedNetworkSecurityPerimeterProfileAccessRuleProperties.fullyQualifiedDomainNames = fullyQualifiedDomainNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("emailAddresses".equals(fieldName)) {
                    List emailAddresses;
                    deserializedNetworkSecurityPerimeterProfileAccessRuleProperties.emailAddresses = emailAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("phoneNumbers".equals(fieldName)) {
                    List phoneNumbers;
                    deserializedNetworkSecurityPerimeterProfileAccessRuleProperties.phoneNumbers = phoneNumbers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterProfileAccessRuleProperties;
        });
    }
}

