/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventInputSchema;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PublisherType;
import java.io.IOException;

public final class NamespaceTopicProperties
implements JsonSerializable<NamespaceTopicProperties> {
    private NamespaceTopicProvisioningState provisioningState;
    private PublisherType publisherType;
    private EventInputSchema inputSchema;
    private Integer eventRetentionInDays;

    public NamespaceTopicProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PublisherType publisherType() {
        return this.publisherType;
    }

    public NamespaceTopicProperties withPublisherType(PublisherType publisherType) {
        this.publisherType = publisherType;
        return this;
    }

    public EventInputSchema inputSchema() {
        return this.inputSchema;
    }

    public NamespaceTopicProperties withInputSchema(EventInputSchema inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    public Integer eventRetentionInDays() {
        return this.eventRetentionInDays;
    }

    public NamespaceTopicProperties withEventRetentionInDays(Integer eventRetentionInDays) {
        this.eventRetentionInDays = eventRetentionInDays;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publisherType", this.publisherType == null ? null : this.publisherType.toString());
        jsonWriter.writeStringField("inputSchema", this.inputSchema == null ? null : this.inputSchema.toString());
        jsonWriter.writeNumberField("eventRetentionInDays", (Number)this.eventRetentionInDays);
        return jsonWriter.writeEndObject();
    }

    public static NamespaceTopicProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NamespaceTopicProperties)jsonReader.readObject(reader -> {
            NamespaceTopicProperties deserializedNamespaceTopicProperties = new NamespaceTopicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNamespaceTopicProperties.provisioningState = NamespaceTopicProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("publisherType".equals(fieldName)) {
                    deserializedNamespaceTopicProperties.publisherType = PublisherType.fromString(reader.getString());
                    continue;
                }
                if ("inputSchema".equals(fieldName)) {
                    deserializedNamespaceTopicProperties.inputSchema = EventInputSchema.fromString(reader.getString());
                    continue;
                }
                if ("eventRetentionInDays".equals(fieldName)) {
                    deserializedNamespaceTopicProperties.eventRetentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespaceTopicProperties;
        });
    }
}

