/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.NamespaceProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import com.azure.resourcemanager.eventgrid.models.TopicSpacesConfiguration;
import com.azure.resourcemanager.eventgrid.models.TopicsConfiguration;
import java.io.IOException;
import java.util.List;

public final class NamespaceProperties
implements JsonSerializable<NamespaceProperties> {
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private NamespaceProvisioningState provisioningState;
    private TopicsConfiguration topicsConfiguration;
    private TopicSpacesConfiguration topicSpacesConfiguration;
    private Boolean isZoneRedundant;
    private PublicNetworkAccess publicNetworkAccess;
    private List<InboundIpRule> inboundIpRules;
    private TlsVersion minimumTlsVersionAllowed;

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public NamespaceProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public NamespaceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public TopicsConfiguration topicsConfiguration() {
        return this.topicsConfiguration;
    }

    public NamespaceProperties withTopicsConfiguration(TopicsConfiguration topicsConfiguration) {
        this.topicsConfiguration = topicsConfiguration;
        return this;
    }

    public TopicSpacesConfiguration topicSpacesConfiguration() {
        return this.topicSpacesConfiguration;
    }

    public NamespaceProperties withTopicSpacesConfiguration(TopicSpacesConfiguration topicSpacesConfiguration) {
        this.topicSpacesConfiguration = topicSpacesConfiguration;
        return this;
    }

    public Boolean isZoneRedundant() {
        return this.isZoneRedundant;
    }

    public NamespaceProperties withIsZoneRedundant(Boolean isZoneRedundant) {
        this.isZoneRedundant = isZoneRedundant;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public NamespaceProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    public NamespaceProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    public NamespaceProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.topicsConfiguration() != null) {
            this.topicsConfiguration().validate();
        }
        if (this.topicSpacesConfiguration() != null) {
            this.topicSpacesConfiguration().validate();
        }
        if (this.inboundIpRules() != null) {
            this.inboundIpRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("topicsConfiguration", (JsonSerializable)this.topicsConfiguration);
        jsonWriter.writeJsonField("topicSpacesConfiguration", (JsonSerializable)this.topicSpacesConfiguration);
        jsonWriter.writeBooleanField("isZoneRedundant", this.isZoneRedundant);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("minimumTlsVersionAllowed", this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        return jsonWriter.writeEndObject();
    }

    public static NamespaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NamespaceProperties)jsonReader.readObject(reader -> {
            NamespaceProperties deserializedNamespaceProperties = new NamespaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedNamespaceProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNamespaceProperties.provisioningState = NamespaceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("topicsConfiguration".equals(fieldName)) {
                    deserializedNamespaceProperties.topicsConfiguration = TopicsConfiguration.fromJson(reader);
                    continue;
                }
                if ("topicSpacesConfiguration".equals(fieldName)) {
                    deserializedNamespaceProperties.topicSpacesConfiguration = TopicSpacesConfiguration.fromJson(reader);
                    continue;
                }
                if ("isZoneRedundant".equals(fieldName)) {
                    deserializedNamespaceProperties.isZoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedNamespaceProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("inboundIpRules".equals(fieldName)) {
                    List inboundIpRules;
                    deserializedNamespaceProperties.inboundIpRules = inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    continue;
                }
                if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedNamespaceProperties.minimumTlsVersionAllowed = TlsVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespaceProperties;
        });
    }
}

