/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMapping;
import java.io.IOException;
import java.util.List;

public final class HybridConnectionEventSubscriptionDestinationProperties
implements JsonSerializable<HybridConnectionEventSubscriptionDestinationProperties> {
    private String resourceId;
    private List<DeliveryAttributeMapping> deliveryAttributeMappings;

    public String resourceId() {
        return this.resourceId;
    }

    public HybridConnectionEventSubscriptionDestinationProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public List<DeliveryAttributeMapping> deliveryAttributeMappings() {
        return this.deliveryAttributeMappings;
    }

    public HybridConnectionEventSubscriptionDestinationProperties withDeliveryAttributeMappings(List<DeliveryAttributeMapping> deliveryAttributeMappings) {
        this.deliveryAttributeMappings = deliveryAttributeMappings;
        return this;
    }

    public void validate() {
        if (this.deliveryAttributeMappings() != null) {
            this.deliveryAttributeMappings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeArrayField("deliveryAttributeMappings", this.deliveryAttributeMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static HybridConnectionEventSubscriptionDestinationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HybridConnectionEventSubscriptionDestinationProperties)jsonReader.readObject(reader -> {
            HybridConnectionEventSubscriptionDestinationProperties deserializedHybridConnectionEventSubscriptionDestinationProperties = new HybridConnectionEventSubscriptionDestinationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedHybridConnectionEventSubscriptionDestinationProperties.resourceId = reader.getString();
                    continue;
                }
                if ("deliveryAttributeMappings".equals(fieldName)) {
                    List deliveryAttributeMappings;
                    deserializedHybridConnectionEventSubscriptionDestinationProperties.deliveryAttributeMappings = deliveryAttributeMappings = reader.readArray(reader1 -> DeliveryAttributeMapping.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridConnectionEventSubscriptionDestinationProperties;
        });
    }
}

