/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.ExtensionTopicProperties;
import java.io.IOException;

public final class ExtensionTopicInner
extends ProxyResource {
    private ExtensionTopicProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ExtensionTopicProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ExtensionTopicInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExtensionTopicProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String systemTopic() {
        return this.innerProperties() == null ? null : this.innerProperties().systemTopic();
    }

    public ExtensionTopicInner withSystemTopic(String systemTopic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExtensionTopicProperties();
        }
        this.innerProperties().withSystemTopic(systemTopic);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ExtensionTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExtensionTopicInner)((Object)jsonReader.readObject(reader -> {
            ExtensionTopicInner deserializedExtensionTopicInner = new ExtensionTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExtensionTopicInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExtensionTopicInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExtensionTopicInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExtensionTopicInner.innerProperties = ExtensionTopicProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedExtensionTopicInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtensionTopicInner;
        }));
    }
}

