/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DataResidencyBoundary;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.io.IOException;
import java.util.List;

public final class DomainUpdateParameterProperties
implements JsonSerializable<DomainUpdateParameterProperties> {
    private PublicNetworkAccess publicNetworkAccess;
    private List<InboundIpRule> inboundIpRules;
    private TlsVersion minimumTlsVersionAllowed;
    private Boolean disableLocalAuth;
    private Boolean autoCreateTopicWithFirstSubscription;
    private Boolean autoDeleteTopicWithLastSubscription;
    private DataResidencyBoundary dataResidencyBoundary;
    private EventTypeInfo eventTypeInfo;

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DomainUpdateParameterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    public DomainUpdateParameterProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    public DomainUpdateParameterProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public DomainUpdateParameterProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Boolean autoCreateTopicWithFirstSubscription() {
        return this.autoCreateTopicWithFirstSubscription;
    }

    public DomainUpdateParameterProperties withAutoCreateTopicWithFirstSubscription(Boolean autoCreateTopicWithFirstSubscription) {
        this.autoCreateTopicWithFirstSubscription = autoCreateTopicWithFirstSubscription;
        return this;
    }

    public Boolean autoDeleteTopicWithLastSubscription() {
        return this.autoDeleteTopicWithLastSubscription;
    }

    public DomainUpdateParameterProperties withAutoDeleteTopicWithLastSubscription(Boolean autoDeleteTopicWithLastSubscription) {
        this.autoDeleteTopicWithLastSubscription = autoDeleteTopicWithLastSubscription;
        return this;
    }

    public DataResidencyBoundary dataResidencyBoundary() {
        return this.dataResidencyBoundary;
    }

    public DomainUpdateParameterProperties withDataResidencyBoundary(DataResidencyBoundary dataResidencyBoundary) {
        this.dataResidencyBoundary = dataResidencyBoundary;
        return this;
    }

    public EventTypeInfo eventTypeInfo() {
        return this.eventTypeInfo;
    }

    public DomainUpdateParameterProperties withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.eventTypeInfo = eventTypeInfo;
        return this;
    }

    public void validate() {
        if (this.inboundIpRules() != null) {
            this.inboundIpRules().forEach(e -> e.validate());
        }
        if (this.eventTypeInfo() != null) {
            this.eventTypeInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("minimumTlsVersionAllowed", this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeBooleanField("autoCreateTopicWithFirstSubscription", this.autoCreateTopicWithFirstSubscription);
        jsonWriter.writeBooleanField("autoDeleteTopicWithLastSubscription", this.autoDeleteTopicWithLastSubscription);
        jsonWriter.writeStringField("dataResidencyBoundary", this.dataResidencyBoundary == null ? null : this.dataResidencyBoundary.toString());
        jsonWriter.writeJsonField("eventTypeInfo", (JsonSerializable)this.eventTypeInfo);
        return jsonWriter.writeEndObject();
    }

    public static DomainUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DomainUpdateParameterProperties)jsonReader.readObject(reader -> {
            DomainUpdateParameterProperties deserializedDomainUpdateParameterProperties = new DomainUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDomainUpdateParameterProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("inboundIpRules".equals(fieldName)) {
                    List inboundIpRules;
                    deserializedDomainUpdateParameterProperties.inboundIpRules = inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    continue;
                }
                if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedDomainUpdateParameterProperties.minimumTlsVersionAllowed = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedDomainUpdateParameterProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoCreateTopicWithFirstSubscription".equals(fieldName)) {
                    deserializedDomainUpdateParameterProperties.autoCreateTopicWithFirstSubscription = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoDeleteTopicWithLastSubscription".equals(fieldName)) {
                    deserializedDomainUpdateParameterProperties.autoDeleteTopicWithLastSubscription = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dataResidencyBoundary".equals(fieldName)) {
                    deserializedDomainUpdateParameterProperties.dataResidencyBoundary = DataResidencyBoundary.fromString(reader.getString());
                    continue;
                }
                if ("eventTypeInfo".equals(fieldName)) {
                    deserializedDomainUpdateParameterProperties.eventTypeInfo = EventTypeInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDomainUpdateParameterProperties;
        });
    }
}

