/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.models.DataResidencyBoundary;
import com.azure.resourcemanager.eventgrid.models.DomainProvisioningState;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.InputSchema;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.io.IOException;
import java.util.List;

public final class DomainProperties
implements JsonSerializable<DomainProperties> {
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private DomainProvisioningState provisioningState;
    private TlsVersion minimumTlsVersionAllowed;
    private String endpoint;
    private InputSchema inputSchema;
    private EventTypeInfo eventTypeInfo;
    private InputSchemaMapping inputSchemaMapping;
    private String metricResourceId;
    private PublicNetworkAccess publicNetworkAccess;
    private List<InboundIpRule> inboundIpRules;
    private Boolean disableLocalAuth;
    private Boolean autoCreateTopicWithFirstSubscription;
    private Boolean autoDeleteTopicWithLastSubscription;
    private DataResidencyBoundary dataResidencyBoundary;

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public DomainProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    public DomainProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public InputSchema inputSchema() {
        return this.inputSchema;
    }

    public DomainProperties withInputSchema(InputSchema inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    public EventTypeInfo eventTypeInfo() {
        return this.eventTypeInfo;
    }

    public DomainProperties withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.eventTypeInfo = eventTypeInfo;
        return this;
    }

    public InputSchemaMapping inputSchemaMapping() {
        return this.inputSchemaMapping;
    }

    public DomainProperties withInputSchemaMapping(InputSchemaMapping inputSchemaMapping) {
        this.inputSchemaMapping = inputSchemaMapping;
        return this;
    }

    public String metricResourceId() {
        return this.metricResourceId;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DomainProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    public DomainProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public DomainProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Boolean autoCreateTopicWithFirstSubscription() {
        return this.autoCreateTopicWithFirstSubscription;
    }

    public DomainProperties withAutoCreateTopicWithFirstSubscription(Boolean autoCreateTopicWithFirstSubscription) {
        this.autoCreateTopicWithFirstSubscription = autoCreateTopicWithFirstSubscription;
        return this;
    }

    public Boolean autoDeleteTopicWithLastSubscription() {
        return this.autoDeleteTopicWithLastSubscription;
    }

    public DomainProperties withAutoDeleteTopicWithLastSubscription(Boolean autoDeleteTopicWithLastSubscription) {
        this.autoDeleteTopicWithLastSubscription = autoDeleteTopicWithLastSubscription;
        return this;
    }

    public DataResidencyBoundary dataResidencyBoundary() {
        return this.dataResidencyBoundary;
    }

    public DomainProperties withDataResidencyBoundary(DataResidencyBoundary dataResidencyBoundary) {
        this.dataResidencyBoundary = dataResidencyBoundary;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.eventTypeInfo() != null) {
            this.eventTypeInfo().validate();
        }
        if (this.inputSchemaMapping() != null) {
            this.inputSchemaMapping().validate();
        }
        if (this.inboundIpRules() != null) {
            this.inboundIpRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("minimumTlsVersionAllowed", this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        jsonWriter.writeStringField("inputSchema", this.inputSchema == null ? null : this.inputSchema.toString());
        jsonWriter.writeJsonField("eventTypeInfo", (JsonSerializable)this.eventTypeInfo);
        jsonWriter.writeJsonField("inputSchemaMapping", (JsonSerializable)this.inputSchemaMapping);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeBooleanField("autoCreateTopicWithFirstSubscription", this.autoCreateTopicWithFirstSubscription);
        jsonWriter.writeBooleanField("autoDeleteTopicWithLastSubscription", this.autoDeleteTopicWithLastSubscription);
        jsonWriter.writeStringField("dataResidencyBoundary", this.dataResidencyBoundary == null ? null : this.dataResidencyBoundary.toString());
        return jsonWriter.writeEndObject();
    }

    public static DomainProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DomainProperties)jsonReader.readObject(reader -> {
            DomainProperties deserializedDomainProperties = new DomainProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedDomainProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDomainProperties.provisioningState = DomainProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedDomainProperties.minimumTlsVersionAllowed = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedDomainProperties.endpoint = reader.getString();
                    continue;
                }
                if ("inputSchema".equals(fieldName)) {
                    deserializedDomainProperties.inputSchema = InputSchema.fromString(reader.getString());
                    continue;
                }
                if ("eventTypeInfo".equals(fieldName)) {
                    deserializedDomainProperties.eventTypeInfo = EventTypeInfo.fromJson(reader);
                    continue;
                }
                if ("inputSchemaMapping".equals(fieldName)) {
                    deserializedDomainProperties.inputSchemaMapping = InputSchemaMapping.fromJson(reader);
                    continue;
                }
                if ("metricResourceId".equals(fieldName)) {
                    deserializedDomainProperties.metricResourceId = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDomainProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("inboundIpRules".equals(fieldName)) {
                    List inboundIpRules;
                    deserializedDomainProperties.inboundIpRules = inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedDomainProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoCreateTopicWithFirstSubscription".equals(fieldName)) {
                    deserializedDomainProperties.autoCreateTopicWithFirstSubscription = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoDeleteTopicWithLastSubscription".equals(fieldName)) {
                    deserializedDomainProperties.autoDeleteTopicWithLastSubscription = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dataResidencyBoundary".equals(fieldName)) {
                    deserializedDomainProperties.dataResidencyBoundary = DataResidencyBoundary.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDomainProperties;
        });
    }
}

