/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientGroupProperties;
import com.azure.resourcemanager.eventgrid.models.ClientGroupProvisioningState;
import java.io.IOException;

public final class ClientGroupInner
extends ProxyResource {
    private ClientGroupProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ClientGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ClientGroupInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientGroupProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String query() {
        return this.innerProperties() == null ? null : this.innerProperties().query();
    }

    public ClientGroupInner withQuery(String query) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientGroupProperties();
        }
        this.innerProperties().withQuery(query);
        return this;
    }

    public ClientGroupProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ClientGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (ClientGroupInner)((Object)jsonReader.readObject(reader -> {
            ClientGroupInner deserializedClientGroupInner = new ClientGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClientGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClientGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClientGroupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClientGroupInner.innerProperties = ClientGroupProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedClientGroupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientGroupInner;
        }));
    }
}

