/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerUpdateDestinationInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerUpdateTopicInfo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ChannelUpdateParametersProperties
implements JsonSerializable<ChannelUpdateParametersProperties> {
    private OffsetDateTime expirationTimeIfNotActivatedUtc;
    private PartnerUpdateDestinationInfo partnerDestinationInfo;
    private PartnerUpdateTopicInfo partnerTopicInfo;

    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.expirationTimeIfNotActivatedUtc;
    }

    public ChannelUpdateParametersProperties withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc;
        return this;
    }

    public PartnerUpdateDestinationInfo partnerDestinationInfo() {
        return this.partnerDestinationInfo;
    }

    public ChannelUpdateParametersProperties withPartnerDestinationInfo(PartnerUpdateDestinationInfo partnerDestinationInfo) {
        this.partnerDestinationInfo = partnerDestinationInfo;
        return this;
    }

    public PartnerUpdateTopicInfo partnerTopicInfo() {
        return this.partnerTopicInfo;
    }

    public ChannelUpdateParametersProperties withPartnerTopicInfo(PartnerUpdateTopicInfo partnerTopicInfo) {
        this.partnerTopicInfo = partnerTopicInfo;
        return this;
    }

    public void validate() {
        if (this.partnerDestinationInfo() != null) {
            this.partnerDestinationInfo().validate();
        }
        if (this.partnerTopicInfo() != null) {
            this.partnerTopicInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expirationTimeIfNotActivatedUtc", this.expirationTimeIfNotActivatedUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeIfNotActivatedUtc));
        jsonWriter.writeJsonField("partnerDestinationInfo", (JsonSerializable)this.partnerDestinationInfo);
        jsonWriter.writeJsonField("partnerTopicInfo", (JsonSerializable)this.partnerTopicInfo);
        return jsonWriter.writeEndObject();
    }

    public static ChannelUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ChannelUpdateParametersProperties)jsonReader.readObject(reader -> {
            ChannelUpdateParametersProperties deserializedChannelUpdateParametersProperties = new ChannelUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expirationTimeIfNotActivatedUtc".equals(fieldName)) {
                    deserializedChannelUpdateParametersProperties.expirationTimeIfNotActivatedUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("partnerDestinationInfo".equals(fieldName)) {
                    deserializedChannelUpdateParametersProperties.partnerDestinationInfo = PartnerUpdateDestinationInfo.fromJson(reader);
                    continue;
                }
                if ("partnerTopicInfo".equals(fieldName)) {
                    deserializedChannelUpdateParametersProperties.partnerTopicInfo = PartnerUpdateTopicInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChannelUpdateParametersProperties;
        });
    }
}

