/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ChannelProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ChannelType;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicInfo;
import com.azure.resourcemanager.eventgrid.models.ReadinessState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ChannelProperties
implements JsonSerializable<ChannelProperties> {
    private ChannelType channelType;
    private PartnerTopicInfo partnerTopicInfo;
    private PartnerDestinationInfo partnerDestinationInfo;
    private String messageForActivation;
    private ChannelProvisioningState provisioningState;
    private ReadinessState readinessState;
    private OffsetDateTime expirationTimeIfNotActivatedUtc;

    public ChannelType channelType() {
        return this.channelType;
    }

    public ChannelProperties withChannelType(ChannelType channelType) {
        this.channelType = channelType;
        return this;
    }

    public PartnerTopicInfo partnerTopicInfo() {
        return this.partnerTopicInfo;
    }

    public ChannelProperties withPartnerTopicInfo(PartnerTopicInfo partnerTopicInfo) {
        this.partnerTopicInfo = partnerTopicInfo;
        return this;
    }

    public PartnerDestinationInfo partnerDestinationInfo() {
        return this.partnerDestinationInfo;
    }

    public ChannelProperties withPartnerDestinationInfo(PartnerDestinationInfo partnerDestinationInfo) {
        this.partnerDestinationInfo = partnerDestinationInfo;
        return this;
    }

    public String messageForActivation() {
        return this.messageForActivation;
    }

    public ChannelProperties withMessageForActivation(String messageForActivation) {
        this.messageForActivation = messageForActivation;
        return this;
    }

    public ChannelProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ChannelProperties withProvisioningState(ChannelProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public ReadinessState readinessState() {
        return this.readinessState;
    }

    public ChannelProperties withReadinessState(ReadinessState readinessState) {
        this.readinessState = readinessState;
        return this;
    }

    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.expirationTimeIfNotActivatedUtc;
    }

    public ChannelProperties withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc;
        return this;
    }

    public void validate() {
        if (this.partnerTopicInfo() != null) {
            this.partnerTopicInfo().validate();
        }
        if (this.partnerDestinationInfo() != null) {
            this.partnerDestinationInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("channelType", this.channelType == null ? null : this.channelType.toString());
        jsonWriter.writeJsonField("partnerTopicInfo", (JsonSerializable)this.partnerTopicInfo);
        jsonWriter.writeJsonField("partnerDestinationInfo", (JsonSerializable)this.partnerDestinationInfo);
        jsonWriter.writeStringField("messageForActivation", this.messageForActivation);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("readinessState", this.readinessState == null ? null : this.readinessState.toString());
        jsonWriter.writeStringField("expirationTimeIfNotActivatedUtc", this.expirationTimeIfNotActivatedUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeIfNotActivatedUtc));
        return jsonWriter.writeEndObject();
    }

    public static ChannelProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ChannelProperties)jsonReader.readObject(reader -> {
            ChannelProperties deserializedChannelProperties = new ChannelProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("channelType".equals(fieldName)) {
                    deserializedChannelProperties.channelType = ChannelType.fromString(reader.getString());
                    continue;
                }
                if ("partnerTopicInfo".equals(fieldName)) {
                    deserializedChannelProperties.partnerTopicInfo = PartnerTopicInfo.fromJson(reader);
                    continue;
                }
                if ("partnerDestinationInfo".equals(fieldName)) {
                    deserializedChannelProperties.partnerDestinationInfo = PartnerDestinationInfo.fromJson(reader);
                    continue;
                }
                if ("messageForActivation".equals(fieldName)) {
                    deserializedChannelProperties.messageForActivation = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedChannelProperties.provisioningState = ChannelProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("readinessState".equals(fieldName)) {
                    deserializedChannelProperties.readinessState = ReadinessState.fromString(reader.getString());
                    continue;
                }
                if ("expirationTimeIfNotActivatedUtc".equals(fieldName)) {
                    deserializedChannelProperties.expirationTimeIfNotActivatedUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChannelProperties;
        });
    }
}

