/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.CaCertificateProperties;
import com.azure.resourcemanager.eventgrid.models.CaCertificateProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CaCertificateInner
extends ProxyResource {
    private CaCertificateProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private CaCertificateProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public CaCertificateInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CaCertificateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String encodedCertificate() {
        return this.innerProperties() == null ? null : this.innerProperties().encodedCertificate();
    }

    public CaCertificateInner withEncodedCertificate(String encodedCertificate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CaCertificateProperties();
        }
        this.innerProperties().withEncodedCertificate(encodedCertificate);
        return this;
    }

    public OffsetDateTime issueTimeInUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().issueTimeInUtc();
    }

    public OffsetDateTime expiryTimeInUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expiryTimeInUtc();
    }

    public CaCertificateProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CaCertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return (CaCertificateInner)((Object)jsonReader.readObject(reader -> {
            CaCertificateInner deserializedCaCertificateInner = new CaCertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCaCertificateInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCaCertificateInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCaCertificateInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCaCertificateInner.innerProperties = CaCertificateProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCaCertificateInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCaCertificateInner;
        }));
    }
}

