/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.EventGridManagementClient;
import com.azure.resourcemanager.eventgrid.implementation.CaCertificatesImpl;
import com.azure.resourcemanager.eventgrid.implementation.ChannelsImpl;
import com.azure.resourcemanager.eventgrid.implementation.ClientGroupsImpl;
import com.azure.resourcemanager.eventgrid.implementation.ClientsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainsImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientBuilder;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.ExtensionTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespaceTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespaceTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespacesImpl;
import com.azure.resourcemanager.eventgrid.implementation.NetworkSecurityPerimeterConfigurationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.OperationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerConfigurationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerDestinationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerNamespacesImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerRegistrationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PermissionBindingsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicSpacesImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicTypesImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.VerifiedPartnersImpl;
import com.azure.resourcemanager.eventgrid.models.CaCertificates;
import com.azure.resourcemanager.eventgrid.models.Channels;
import com.azure.resourcemanager.eventgrid.models.ClientGroups;
import com.azure.resourcemanager.eventgrid.models.Clients;
import com.azure.resourcemanager.eventgrid.models.DomainEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.DomainTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.DomainTopics;
import com.azure.resourcemanager.eventgrid.models.Domains;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.ExtensionTopics;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopics;
import com.azure.resourcemanager.eventgrid.models.Namespaces;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurations;
import com.azure.resourcemanager.eventgrid.models.Operations;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurations;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinations;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaces;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrations;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.PartnerTopics;
import com.azure.resourcemanager.eventgrid.models.PermissionBindings;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnections;
import com.azure.resourcemanager.eventgrid.models.PrivateLinkResources;
import com.azure.resourcemanager.eventgrid.models.SystemTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.SystemTopics;
import com.azure.resourcemanager.eventgrid.models.TopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.TopicSpaces;
import com.azure.resourcemanager.eventgrid.models.TopicTypes;
import com.azure.resourcemanager.eventgrid.models.Topics;
import com.azure.resourcemanager.eventgrid.models.VerifiedPartners;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class EventGridManager {
    private CaCertificates caCertificates;
    private Channels channels;
    private ClientGroups clientGroups;
    private Clients clients;
    private Domains domains;
    private DomainTopics domainTopics;
    private DomainTopicEventSubscriptions domainTopicEventSubscriptions;
    private TopicEventSubscriptions topicEventSubscriptions;
    private DomainEventSubscriptions domainEventSubscriptions;
    private EventSubscriptions eventSubscriptions;
    private SystemTopicEventSubscriptions systemTopicEventSubscriptions;
    private NamespaceTopicEventSubscriptions namespaceTopicEventSubscriptions;
    private PartnerTopicEventSubscriptions partnerTopicEventSubscriptions;
    private Namespaces namespaces;
    private NamespaceTopics namespaceTopics;
    private Operations operations;
    private PartnerConfigurations partnerConfigurations;
    private PartnerDestinations partnerDestinations;
    private PartnerNamespaces partnerNamespaces;
    private PartnerRegistrations partnerRegistrations;
    private PartnerTopics partnerTopics;
    private NetworkSecurityPerimeterConfigurations networkSecurityPerimeterConfigurations;
    private PermissionBindings permissionBindings;
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private SystemTopics systemTopics;
    private Topics topics;
    private ExtensionTopics extensionTopics;
    private TopicSpaces topicSpaces;
    private TopicTypes topicTypes;
    private VerifiedPartners verifiedPartners;
    private final EventGridManagementClient clientObject;

    private EventGridManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new EventGridManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static EventGridManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return EventGridManager.configure().authenticate(credential, profile);
    }

    public static EventGridManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new EventGridManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public CaCertificates caCertificates() {
        if (this.caCertificates == null) {
            this.caCertificates = new CaCertificatesImpl(this.clientObject.getCaCertificates(), this);
        }
        return this.caCertificates;
    }

    public Channels channels() {
        if (this.channels == null) {
            this.channels = new ChannelsImpl(this.clientObject.getChannels(), this);
        }
        return this.channels;
    }

    public ClientGroups clientGroups() {
        if (this.clientGroups == null) {
            this.clientGroups = new ClientGroupsImpl(this.clientObject.getClientGroups(), this);
        }
        return this.clientGroups;
    }

    public Clients clients() {
        if (this.clients == null) {
            this.clients = new ClientsImpl(this.clientObject.getClients(), this);
        }
        return this.clients;
    }

    public Domains domains() {
        if (this.domains == null) {
            this.domains = new DomainsImpl(this.clientObject.getDomains(), this);
        }
        return this.domains;
    }

    public DomainTopics domainTopics() {
        if (this.domainTopics == null) {
            this.domainTopics = new DomainTopicsImpl(this.clientObject.getDomainTopics(), this);
        }
        return this.domainTopics;
    }

    public DomainTopicEventSubscriptions domainTopicEventSubscriptions() {
        if (this.domainTopicEventSubscriptions == null) {
            this.domainTopicEventSubscriptions = new DomainTopicEventSubscriptionsImpl(this.clientObject.getDomainTopicEventSubscriptions(), this);
        }
        return this.domainTopicEventSubscriptions;
    }

    public TopicEventSubscriptions topicEventSubscriptions() {
        if (this.topicEventSubscriptions == null) {
            this.topicEventSubscriptions = new TopicEventSubscriptionsImpl(this.clientObject.getTopicEventSubscriptions(), this);
        }
        return this.topicEventSubscriptions;
    }

    public DomainEventSubscriptions domainEventSubscriptions() {
        if (this.domainEventSubscriptions == null) {
            this.domainEventSubscriptions = new DomainEventSubscriptionsImpl(this.clientObject.getDomainEventSubscriptions(), this);
        }
        return this.domainEventSubscriptions;
    }

    public EventSubscriptions eventSubscriptions() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = new EventSubscriptionsImpl(this.clientObject.getEventSubscriptions(), this);
        }
        return this.eventSubscriptions;
    }

    public SystemTopicEventSubscriptions systemTopicEventSubscriptions() {
        if (this.systemTopicEventSubscriptions == null) {
            this.systemTopicEventSubscriptions = new SystemTopicEventSubscriptionsImpl(this.clientObject.getSystemTopicEventSubscriptions(), this);
        }
        return this.systemTopicEventSubscriptions;
    }

    public NamespaceTopicEventSubscriptions namespaceTopicEventSubscriptions() {
        if (this.namespaceTopicEventSubscriptions == null) {
            this.namespaceTopicEventSubscriptions = new NamespaceTopicEventSubscriptionsImpl(this.clientObject.getNamespaceTopicEventSubscriptions(), this);
        }
        return this.namespaceTopicEventSubscriptions;
    }

    public PartnerTopicEventSubscriptions partnerTopicEventSubscriptions() {
        if (this.partnerTopicEventSubscriptions == null) {
            this.partnerTopicEventSubscriptions = new PartnerTopicEventSubscriptionsImpl(this.clientObject.getPartnerTopicEventSubscriptions(), this);
        }
        return this.partnerTopicEventSubscriptions;
    }

    public Namespaces namespaces() {
        if (this.namespaces == null) {
            this.namespaces = new NamespacesImpl(this.clientObject.getNamespaces(), this);
        }
        return this.namespaces;
    }

    public NamespaceTopics namespaceTopics() {
        if (this.namespaceTopics == null) {
            this.namespaceTopics = new NamespaceTopicsImpl(this.clientObject.getNamespaceTopics(), this);
        }
        return this.namespaceTopics;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public PartnerConfigurations partnerConfigurations() {
        if (this.partnerConfigurations == null) {
            this.partnerConfigurations = new PartnerConfigurationsImpl(this.clientObject.getPartnerConfigurations(), this);
        }
        return this.partnerConfigurations;
    }

    public PartnerDestinations partnerDestinations() {
        if (this.partnerDestinations == null) {
            this.partnerDestinations = new PartnerDestinationsImpl(this.clientObject.getPartnerDestinations(), this);
        }
        return this.partnerDestinations;
    }

    public PartnerNamespaces partnerNamespaces() {
        if (this.partnerNamespaces == null) {
            this.partnerNamespaces = new PartnerNamespacesImpl(this.clientObject.getPartnerNamespaces(), this);
        }
        return this.partnerNamespaces;
    }

    public PartnerRegistrations partnerRegistrations() {
        if (this.partnerRegistrations == null) {
            this.partnerRegistrations = new PartnerRegistrationsImpl(this.clientObject.getPartnerRegistrations(), this);
        }
        return this.partnerRegistrations;
    }

    public PartnerTopics partnerTopics() {
        if (this.partnerTopics == null) {
            this.partnerTopics = new PartnerTopicsImpl(this.clientObject.getPartnerTopics(), this);
        }
        return this.partnerTopics;
    }

    public NetworkSecurityPerimeterConfigurations networkSecurityPerimeterConfigurations() {
        if (this.networkSecurityPerimeterConfigurations == null) {
            this.networkSecurityPerimeterConfigurations = new NetworkSecurityPerimeterConfigurationsImpl(this.clientObject.getNetworkSecurityPerimeterConfigurations(), this);
        }
        return this.networkSecurityPerimeterConfigurations;
    }

    public PermissionBindings permissionBindings() {
        if (this.permissionBindings == null) {
            this.permissionBindings = new PermissionBindingsImpl(this.clientObject.getPermissionBindings(), this);
        }
        return this.permissionBindings;
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public SystemTopics systemTopics() {
        if (this.systemTopics == null) {
            this.systemTopics = new SystemTopicsImpl(this.clientObject.getSystemTopics(), this);
        }
        return this.systemTopics;
    }

    public Topics topics() {
        if (this.topics == null) {
            this.topics = new TopicsImpl(this.clientObject.getTopics(), this);
        }
        return this.topics;
    }

    public ExtensionTopics extensionTopics() {
        if (this.extensionTopics == null) {
            this.extensionTopics = new ExtensionTopicsImpl(this.clientObject.getExtensionTopics(), this);
        }
        return this.extensionTopics;
    }

    public TopicSpaces topicSpaces() {
        if (this.topicSpaces == null) {
            this.topicSpaces = new TopicSpacesImpl(this.clientObject.getTopicSpaces(), this);
        }
        return this.topicSpaces;
    }

    public TopicTypes topicTypes() {
        if (this.topicTypes == null) {
            this.topicTypes = new TopicTypesImpl(this.clientObject.getTopicTypes(), this);
        }
        return this.topicTypes;
    }

    public VerifiedPartners verifiedPartners() {
        if (this.verifiedPartners == null) {
            this.verifiedPartners = new VerifiedPartnersImpl(this.clientObject.getVerifiedPartners(), this);
        }
        return this.verifiedPartners;
    }

    public EventGridManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-eventgrid.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public EventGridManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.eventgrid").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new EventGridManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

