/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CustomDomainConfiguration;
import com.azure.resourcemanager.eventgrid.models.RoutingEnrichments;
import com.azure.resourcemanager.eventgrid.models.RoutingIdentityInfo;
import com.azure.resourcemanager.eventgrid.models.TopicSpacesConfigurationState;
import java.io.IOException;
import java.util.List;

public final class UpdateTopicSpacesConfigurationInfo
implements JsonSerializable<UpdateTopicSpacesConfigurationInfo> {
    private TopicSpacesConfigurationState state;
    private String routeTopicResourceId;
    private RoutingEnrichments routingEnrichments;
    private Integer maximumSessionExpiryInHours;
    private Integer maximumClientSessionsPerAuthenticationName;
    private RoutingIdentityInfo routingIdentityInfo;
    private List<CustomDomainConfiguration> customDomains;

    public TopicSpacesConfigurationState state() {
        return this.state;
    }

    public UpdateTopicSpacesConfigurationInfo withState(TopicSpacesConfigurationState state) {
        this.state = state;
        return this;
    }

    public String routeTopicResourceId() {
        return this.routeTopicResourceId;
    }

    public UpdateTopicSpacesConfigurationInfo withRouteTopicResourceId(String routeTopicResourceId) {
        this.routeTopicResourceId = routeTopicResourceId;
        return this;
    }

    public RoutingEnrichments routingEnrichments() {
        return this.routingEnrichments;
    }

    public UpdateTopicSpacesConfigurationInfo withRoutingEnrichments(RoutingEnrichments routingEnrichments) {
        this.routingEnrichments = routingEnrichments;
        return this;
    }

    public Integer maximumSessionExpiryInHours() {
        return this.maximumSessionExpiryInHours;
    }

    public UpdateTopicSpacesConfigurationInfo withMaximumSessionExpiryInHours(Integer maximumSessionExpiryInHours) {
        this.maximumSessionExpiryInHours = maximumSessionExpiryInHours;
        return this;
    }

    public Integer maximumClientSessionsPerAuthenticationName() {
        return this.maximumClientSessionsPerAuthenticationName;
    }

    public UpdateTopicSpacesConfigurationInfo withMaximumClientSessionsPerAuthenticationName(Integer maximumClientSessionsPerAuthenticationName) {
        this.maximumClientSessionsPerAuthenticationName = maximumClientSessionsPerAuthenticationName;
        return this;
    }

    public RoutingIdentityInfo routingIdentityInfo() {
        return this.routingIdentityInfo;
    }

    public UpdateTopicSpacesConfigurationInfo withRoutingIdentityInfo(RoutingIdentityInfo routingIdentityInfo) {
        this.routingIdentityInfo = routingIdentityInfo;
        return this;
    }

    public List<CustomDomainConfiguration> customDomains() {
        return this.customDomains;
    }

    public UpdateTopicSpacesConfigurationInfo withCustomDomains(List<CustomDomainConfiguration> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    public void validate() {
        if (this.routingEnrichments() != null) {
            this.routingEnrichments().validate();
        }
        if (this.routingIdentityInfo() != null) {
            this.routingIdentityInfo().validate();
        }
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("routeTopicResourceId", this.routeTopicResourceId);
        jsonWriter.writeJsonField("routingEnrichments", (JsonSerializable)this.routingEnrichments);
        jsonWriter.writeNumberField("maximumSessionExpiryInHours", (Number)this.maximumSessionExpiryInHours);
        jsonWriter.writeNumberField("maximumClientSessionsPerAuthenticationName", (Number)this.maximumClientSessionsPerAuthenticationName);
        jsonWriter.writeJsonField("routingIdentityInfo", (JsonSerializable)this.routingIdentityInfo);
        jsonWriter.writeArrayField("customDomains", this.customDomains, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static UpdateTopicSpacesConfigurationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateTopicSpacesConfigurationInfo)jsonReader.readObject(reader -> {
            UpdateTopicSpacesConfigurationInfo deserializedUpdateTopicSpacesConfigurationInfo = new UpdateTopicSpacesConfigurationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.state = TopicSpacesConfigurationState.fromString(reader.getString());
                    continue;
                }
                if ("routeTopicResourceId".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.routeTopicResourceId = reader.getString();
                    continue;
                }
                if ("routingEnrichments".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.routingEnrichments = RoutingEnrichments.fromJson(reader);
                    continue;
                }
                if ("maximumSessionExpiryInHours".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.maximumSessionExpiryInHours = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maximumClientSessionsPerAuthenticationName".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.maximumClientSessionsPerAuthenticationName = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("routingIdentityInfo".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.routingIdentityInfo = RoutingIdentityInfo.fromJson(reader);
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List customDomains;
                    deserializedUpdateTopicSpacesConfigurationInfo.customDomains = customDomains = reader.readArray(reader1 -> CustomDomainConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateTopicSpacesConfigurationInfo;
        });
    }
}

