/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CustomDomainConfiguration;
import java.io.IOException;
import java.util.List;

public final class TopicsConfiguration
implements JsonSerializable<TopicsConfiguration> {
    private String hostname;
    private List<CustomDomainConfiguration> customDomains;

    public String hostname() {
        return this.hostname;
    }

    public List<CustomDomainConfiguration> customDomains() {
        return this.customDomains;
    }

    public TopicsConfiguration withCustomDomains(List<CustomDomainConfiguration> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    public void validate() {
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("customDomains", this.customDomains, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TopicsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (TopicsConfiguration)jsonReader.readObject(reader -> {
            TopicsConfiguration deserializedTopicsConfiguration = new TopicsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hostname".equals(fieldName)) {
                    deserializedTopicsConfiguration.hostname = reader.getString();
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List customDomains;
                    deserializedTopicsConfiguration.customDomains = customDomains = reader.readArray(reader1 -> CustomDomainConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopicsConfiguration;
        });
    }
}

