/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeListResult;
import com.azure.resourcemanager.eventgrid.models.DeliveryConfiguration;
import com.azure.resourcemanager.eventgrid.models.DeliverySchema;
import com.azure.resourcemanager.eventgrid.models.FiltersConfiguration;
import com.azure.resourcemanager.eventgrid.models.SubscriptionFullUrl;
import com.azure.resourcemanager.eventgrid.models.SubscriptionProvisioningState;
import java.time.OffsetDateTime;

public interface Subscription {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public SubscriptionProvisioningState provisioningState();

    public DeliveryConfiguration deliveryConfiguration();

    public DeliverySchema eventDeliverySchema();

    public FiltersConfiguration filtersConfiguration();

    public OffsetDateTime expirationTimeUtc();

    public String resourceGroupName();

    public SubscriptionInner innerModel();

    public Update update();

    public Subscription refresh();

    public Subscription refresh(Context var1);

    public Response<DeliveryAttributeListResult> getDeliveryAttributesWithResponse(Context var1);

    public DeliveryAttributeListResult getDeliveryAttributes();

    public Response<SubscriptionFullUrl> getFullUrlWithResponse(Context var1);

    public SubscriptionFullUrl getFullUrl();

    public static interface UpdateStages {

        public static interface WithExpirationTimeUtc {
            public Update withExpirationTimeUtc(OffsetDateTime var1);
        }

        public static interface WithFiltersConfiguration {
            public Update withFiltersConfiguration(FiltersConfiguration var1);
        }

        public static interface WithEventDeliverySchema {
            public Update withEventDeliverySchema(DeliverySchema var1);
        }

        public static interface WithDeliveryConfiguration {
            public Update withDeliveryConfiguration(DeliveryConfiguration var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDeliveryConfiguration,
    UpdateStages.WithEventDeliverySchema,
    UpdateStages.WithFiltersConfiguration,
    UpdateStages.WithExpirationTimeUtc {
        public Subscription apply();

        public Subscription apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithExpirationTimeUtc {
            public WithCreate withExpirationTimeUtc(OffsetDateTime var1);
        }

        public static interface WithFiltersConfiguration {
            public WithCreate withFiltersConfiguration(FiltersConfiguration var1);
        }

        public static interface WithEventDeliverySchema {
            public WithCreate withEventDeliverySchema(DeliverySchema var1);
        }

        public static interface WithDeliveryConfiguration {
            public WithCreate withDeliveryConfiguration(DeliveryConfiguration var1);
        }

        public static interface WithCreate
        extends WithDeliveryConfiguration,
        WithEventDeliverySchema,
        WithFiltersConfiguration,
        WithExpirationTimeUtc {
            public Subscription create();

            public Subscription create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingTopic(String var1, String var2, String var3);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

