/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilterOperatorType;
import java.io.IOException;
import java.util.List;

public final class StringInAdvancedFilter
extends AdvancedFilter {
    private AdvancedFilterOperatorType operatorType = AdvancedFilterOperatorType.STRING_IN;
    private List<String> values;

    @Override
    public AdvancedFilterOperatorType operatorType() {
        return this.operatorType;
    }

    public List<String> values() {
        return this.values;
    }

    public StringInAdvancedFilter withValues(List<String> values) {
        this.values = values;
        return this;
    }

    @Override
    public StringInAdvancedFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StringInAdvancedFilter fromJson(JsonReader jsonReader) throws IOException {
        return (StringInAdvancedFilter)jsonReader.readObject(reader -> {
            StringInAdvancedFilter deserializedStringInAdvancedFilter = new StringInAdvancedFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedStringInAdvancedFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedStringInAdvancedFilter.operatorType = AdvancedFilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedStringInAdvancedFilter.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStringInAdvancedFilter;
        });
    }
}

