/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Filter;
import com.azure.resourcemanager.eventgrid.models.FilterOperatorType;
import java.io.IOException;
import java.util.List;

public final class StringContainsFilter
extends Filter {
    private FilterOperatorType operatorType = FilterOperatorType.STRING_CONTAINS;
    private List<String> values;

    @Override
    public FilterOperatorType operatorType() {
        return this.operatorType;
    }

    public List<String> values() {
        return this.values;
    }

    public StringContainsFilter withValues(List<String> values) {
        this.values = values;
        return this;
    }

    @Override
    public StringContainsFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StringContainsFilter fromJson(JsonReader jsonReader) throws IOException {
        return (StringContainsFilter)jsonReader.readObject(reader -> {
            StringContainsFilter deserializedStringContainsFilter = new StringContainsFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedStringContainsFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedStringContainsFilter.operatorType = FilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedStringContainsFilter.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStringContainsFilter;
        });
    }
}

