/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.StaticDeliveryAttributeMappingProperties;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMapping;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMappingType;
import java.io.IOException;

public final class StaticDeliveryAttributeMapping
extends DeliveryAttributeMapping {
    private DeliveryAttributeMappingType type = DeliveryAttributeMappingType.STATIC;
    private StaticDeliveryAttributeMappingProperties innerProperties;

    @Override
    public DeliveryAttributeMappingType type() {
        return this.type;
    }

    StaticDeliveryAttributeMappingProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public StaticDeliveryAttributeMapping withName(String name) {
        super.withName(name);
        return this;
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public StaticDeliveryAttributeMapping withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticDeliveryAttributeMappingProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    public Boolean isSecret() {
        return this.innerProperties() == null ? null : this.innerProperties().isSecret();
    }

    public StaticDeliveryAttributeMapping withIsSecret(Boolean isSecret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticDeliveryAttributeMappingProperties();
        }
        this.innerProperties().withIsSecret(isSecret);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StaticDeliveryAttributeMapping fromJson(JsonReader jsonReader) throws IOException {
        return (StaticDeliveryAttributeMapping)jsonReader.readObject(reader -> {
            StaticDeliveryAttributeMapping deserializedStaticDeliveryAttributeMapping = new StaticDeliveryAttributeMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStaticDeliveryAttributeMapping.withName(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStaticDeliveryAttributeMapping.type = DeliveryAttributeMappingType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStaticDeliveryAttributeMapping.innerProperties = StaticDeliveryAttributeMappingProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticDeliveryAttributeMapping;
        });
    }
}

