/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerTopicInner;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicProvisioningState;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public interface PartnerTopic {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public IdentityInfo identity();

    public UUID partnerRegistrationImmutableId();

    public String source();

    public EventTypeInfo eventTypeInfo();

    public OffsetDateTime expirationTimeIfNotActivatedUtc();

    public PartnerTopicProvisioningState provisioningState();

    public PartnerTopicActivationState activationState();

    public String partnerTopicFriendlyDescription();

    public String messageForActivation();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public PartnerTopicInner innerModel();

    public Update update();

    public PartnerTopic refresh();

    public PartnerTopic refresh(Context var1);

    public Response<PartnerTopic> activateWithResponse(Context var1);

    public PartnerTopic activate();

    public Response<PartnerTopic> deactivateWithResponse(Context var1);

    public PartnerTopic deactivate();

    public static interface UpdateStages {

        public static interface WithIdentity {
            public Update withIdentity(IdentityInfo var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity {
        public PartnerTopic apply();

        public PartnerTopic apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMessageForActivation {
            public WithCreate withMessageForActivation(String var1);
        }

        public static interface WithPartnerTopicFriendlyDescription {
            public WithCreate withPartnerTopicFriendlyDescription(String var1);
        }

        public static interface WithActivationState {
            public WithCreate withActivationState(PartnerTopicActivationState var1);
        }

        public static interface WithExpirationTimeIfNotActivatedUtc {
            public WithCreate withExpirationTimeIfNotActivatedUtc(OffsetDateTime var1);
        }

        public static interface WithEventTypeInfo {
            public WithCreate withEventTypeInfo(EventTypeInfo var1);
        }

        public static interface WithSource {
            public WithCreate withSource(String var1);
        }

        public static interface WithPartnerRegistrationImmutableId {
            public WithCreate withPartnerRegistrationImmutableId(UUID var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(IdentityInfo var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithPartnerRegistrationImmutableId,
        WithSource,
        WithEventTypeInfo,
        WithExpirationTimeIfNotActivatedUtc,
        WithActivationState,
        WithPartnerTopicFriendlyDescription,
        WithMessageForActivation {
            public PartnerTopic create();

            public PartnerTopic create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

