/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilterOperatorType;
import java.io.IOException;
import java.util.List;

public final class NumberNotInRangeAdvancedFilter
extends AdvancedFilter {
    private AdvancedFilterOperatorType operatorType = AdvancedFilterOperatorType.NUMBER_NOT_IN_RANGE;
    private List<List<Double>> values;

    @Override
    public AdvancedFilterOperatorType operatorType() {
        return this.operatorType;
    }

    public List<List<Double>> values() {
        return this.values;
    }

    public NumberNotInRangeAdvancedFilter withValues(List<List<Double>> values) {
        this.values = values;
        return this;
    }

    @Override
    public NumberNotInRangeAdvancedFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeDouble(element1.doubleValue())));
        return jsonWriter.writeEndObject();
    }

    public static NumberNotInRangeAdvancedFilter fromJson(JsonReader jsonReader) throws IOException {
        return (NumberNotInRangeAdvancedFilter)jsonReader.readObject(reader -> {
            NumberNotInRangeAdvancedFilter deserializedNumberNotInRangeAdvancedFilter = new NumberNotInRangeAdvancedFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedNumberNotInRangeAdvancedFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedNumberNotInRangeAdvancedFilter.operatorType = AdvancedFilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedNumberNotInRangeAdvancedFilter.values = values = reader.readArray(reader1 -> reader1.readArray(reader2 -> reader2.getDouble()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNumberNotInRangeAdvancedFilter;
        });
    }
}

