/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Filter;
import java.io.IOException;
import java.util.List;

public final class FiltersConfiguration
implements JsonSerializable<FiltersConfiguration> {
    private List<String> includedEventTypes;
    private List<Filter> filters;

    public List<String> includedEventTypes() {
        return this.includedEventTypes;
    }

    public FiltersConfiguration withIncludedEventTypes(List<String> includedEventTypes) {
        this.includedEventTypes = includedEventTypes;
        return this;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public FiltersConfiguration withFilters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("includedEventTypes", this.includedEventTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FiltersConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (FiltersConfiguration)jsonReader.readObject(reader -> {
            FiltersConfiguration deserializedFiltersConfiguration = new FiltersConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("includedEventTypes".equals(fieldName)) {
                    List includedEventTypes;
                    deserializedFiltersConfiguration.includedEventTypes = includedEventTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedFiltersConfiguration.filters = filters = reader.readArray(reader1 -> Filter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFiltersConfiguration;
        });
    }
}

