/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionIdentity;
import java.io.IOException;

public final class DeadLetterWithResourceIdentity
implements JsonSerializable<DeadLetterWithResourceIdentity> {
    private EventSubscriptionIdentity identity;
    private DeadLetterDestination deadLetterDestination;

    public EventSubscriptionIdentity identity() {
        return this.identity;
    }

    public DeadLetterWithResourceIdentity withIdentity(EventSubscriptionIdentity identity) {
        this.identity = identity;
        return this;
    }

    public DeadLetterDestination deadLetterDestination() {
        return this.deadLetterDestination;
    }

    public DeadLetterWithResourceIdentity withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        this.deadLetterDestination = deadLetterDestination;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.deadLetterDestination() != null) {
            this.deadLetterDestination().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("deadLetterDestination", (JsonSerializable)this.deadLetterDestination);
        return jsonWriter.writeEndObject();
    }

    public static DeadLetterWithResourceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (DeadLetterWithResourceIdentity)jsonReader.readObject(reader -> {
            DeadLetterWithResourceIdentity deserializedDeadLetterWithResourceIdentity = new DeadLetterWithResourceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedDeadLetterWithResourceIdentity.identity = EventSubscriptionIdentity.fromJson(reader);
                    continue;
                }
                if ("deadLetterDestination".equals(fieldName)) {
                    deserializedDeadLetterWithResourceIdentity.deadLetterDestination = DeadLetterDestination.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeadLetterWithResourceIdentity;
        });
    }
}

